<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductionTimetableSubscriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Subscription Request for Production Timetable Service.
 * @subpackage Structs
 */
class ProductionTimetableSubscriptionStructure extends AbstractSubscriptionStructure
{
    /**
     * The ProductionTimetableRequest
     * Meta informations extracted from the WSDL
     * - ref: ProductionTimetableRequest
     * @var \StructType\ProductionTimetableRequestStructure
     */
    public $ProductionTimetableRequest;
    /**
     * The IncrementalUpdates
     * @var bool
     */
    public $IncrementalUpdates;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for ProductionTimetableSubscriptionStructure
     * @uses ProductionTimetableSubscriptionStructure::setProductionTimetableRequest()
     * @uses ProductionTimetableSubscriptionStructure::setIncrementalUpdates()
     * @uses ProductionTimetableSubscriptionStructure::setExtensions()
     * @param \StructType\ProductionTimetableRequestStructure $productionTimetableRequest
     * @param bool $incrementalUpdates
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\ProductionTimetableRequestStructure $productionTimetableRequest = null, $incrementalUpdates = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setProductionTimetableRequest($productionTimetableRequest)
            ->setIncrementalUpdates($incrementalUpdates)
            ->setExtensions($extensions);
    }
    /**
     * Get ProductionTimetableRequest value
     * @return \StructType\ProductionTimetableRequestStructure|null
     */
    public function getProductionTimetableRequest()
    {
        return $this->ProductionTimetableRequest;
    }
    /**
     * Set ProductionTimetableRequest value
     * @param \StructType\ProductionTimetableRequestStructure $productionTimetableRequest
     * @return \StructType\ProductionTimetableSubscriptionStructure
     */
    public function setProductionTimetableRequest(\StructType\ProductionTimetableRequestStructure $productionTimetableRequest = null)
    {
        $this->ProductionTimetableRequest = $productionTimetableRequest;
        return $this;
    }
    /**
     * Get IncrementalUpdates value
     * @return bool|null
     */
    public function getIncrementalUpdates()
    {
        return $this->IncrementalUpdates;
    }
    /**
     * Set IncrementalUpdates value
     * @param bool $incrementalUpdates
     * @return \StructType\ProductionTimetableSubscriptionStructure
     */
    public function setIncrementalUpdates($incrementalUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($incrementalUpdates) && !is_bool($incrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incrementalUpdates)), __LINE__);
        }
        $this->IncrementalUpdates = $incrementalUpdates;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ProductionTimetableSubscriptionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductionTimetableSubscriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
