<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductionTimetableRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Production Timetables.
 * @subpackage Structs
 */
class ProductionTimetableRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The ValidityPeriod
     * @var \StructType\ClosedTimestampRangeStructure
     */
    public $ValidityPeriod;
    /**
     * The TimetableVersionRef
     * @var \StructType\VersionRefStructure
     */
    public $TimetableVersionRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The Lines
     * @var \StructType\Lines
     */
    public $Lines;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The IncrementalUpdates
     * @var bool
     */
    public $IncrementalUpdates;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ProductionTimetableRequestStructure
     * @uses ProductionTimetableRequestStructure::setValidityPeriod()
     * @uses ProductionTimetableRequestStructure::setTimetableVersionRef()
     * @uses ProductionTimetableRequestStructure::setOperatorRef()
     * @uses ProductionTimetableRequestStructure::setLines()
     * @uses ProductionTimetableRequestStructure::setLanguage()
     * @uses ProductionTimetableRequestStructure::setIncludeTranslations()
     * @uses ProductionTimetableRequestStructure::setIncrementalUpdates()
     * @uses ProductionTimetableRequestStructure::setExtensions()
     * @uses ProductionTimetableRequestStructure::setVersion()
     * @param \StructType\ClosedTimestampRangeStructure $validityPeriod
     * @param \StructType\VersionRefStructure $timetableVersionRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\Lines $lines
     * @param string $language
     * @param bool $includeTranslations
     * @param bool $incrementalUpdates
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\ClosedTimestampRangeStructure $validityPeriod = null, \StructType\VersionRefStructure $timetableVersionRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\Lines $lines = null, $language = null, $includeTranslations = null, $incrementalUpdates = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setValidityPeriod($validityPeriod)
            ->setTimetableVersionRef($timetableVersionRef)
            ->setOperatorRef($operatorRef)
            ->setLines($lines)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setIncrementalUpdates($incrementalUpdates)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\ClosedTimestampRangeStructure|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\ClosedTimestampRangeStructure $validityPeriod
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setValidityPeriod(\StructType\ClosedTimestampRangeStructure $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get TimetableVersionRef value
     * @return \StructType\VersionRefStructure|null
     */
    public function getTimetableVersionRef()
    {
        return $this->TimetableVersionRef;
    }
    /**
     * Set TimetableVersionRef value
     * @param \StructType\VersionRefStructure $timetableVersionRef
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setTimetableVersionRef(\StructType\VersionRefStructure $timetableVersionRef = null)
    {
        $this->TimetableVersionRef = $timetableVersionRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get Lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \StructType\Lines $lines
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get IncrementalUpdates value
     * @return bool|null
     */
    public function getIncrementalUpdates()
    {
        return $this->IncrementalUpdates;
    }
    /**
     * Set IncrementalUpdates value
     * @param bool $incrementalUpdates
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setIncrementalUpdates($incrementalUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($incrementalUpdates) && !is_bool($incrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incrementalUpdates)), __LINE__);
        }
        $this->IncrementalUpdates = $incrementalUpdates;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductionTimetableRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
