<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProducerRequestEndpointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Unique reference to request to the producer. May be used to reference request in subsequent interactions. Used for WSDL. | If request has been proxied by an intermediate aggregting system, trackng informattion relating to
 * the original requestor. This allows the aggregation to be stateless.
 * @subpackage Structs
 */
class ProducerRequestEndpointStructure extends AuthenticatedRequestStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The ProducerRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ProducerRef;
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for ProducerRequestEndpointStructure
     * @uses ProducerRequestEndpointStructure::setAddress()
     * @uses ProducerRequestEndpointStructure::setProducerRef()
     * @uses ProducerRequestEndpointStructure::setMessageIdentifier()
     * @uses ProducerRequestEndpointStructure::setDelegatorAddress()
     * @uses ProducerRequestEndpointStructure::setDelegatorRef()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $producerRef
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $producerRef = null, \StructType\MessageQualifierStructure $messageIdentifier = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setAddress($address)
            ->setProducerRef($producerRef)
            ->setMessageIdentifier($messageIdentifier)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ProducerRequestEndpointStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ProducerRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getProducerRef()
    {
        return $this->ProducerRef;
    }
    /**
     * Set ProducerRef value
     * @param \StructType\ParticipantRefStructure $producerRef
     * @return \StructType\ProducerRequestEndpointStructure
     */
    public function setProducerRef(\StructType\ParticipantRefStructure $producerRef = null)
    {
        $this->ProducerRef = $producerRef;
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\ProducerRequestEndpointStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\ProducerRequestEndpointStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\ProducerRequestEndpointStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProducerRequestEndpointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
