<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviousCallsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Ordered list of CALLs at previous stop.
 * @subpackage Structs
 */
class PreviousCallsStructure extends AbstractStructBase
{
    /**
     * The PreviousCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PreviousCallStructure[]
     */
    public $PreviousCall;
    /**
     * Constructor method for PreviousCallsStructure
     * @uses PreviousCallsStructure::setPreviousCall()
     * @param \StructType\PreviousCallStructure[] $previousCall
     */
    public function __construct(array $previousCall = array())
    {
        $this
            ->setPreviousCall($previousCall);
    }
    /**
     * Get PreviousCall value
     * @return \StructType\PreviousCallStructure[]|null
     */
    public function getPreviousCall()
    {
        return $this->PreviousCall;
    }
    /**
     * Set PreviousCall value
     * @throws \InvalidArgumentException
     * @param \StructType\PreviousCallStructure[] $previousCall
     * @return \StructType\PreviousCallsStructure
     */
    public function setPreviousCall(array $previousCall = array())
    {
        foreach ($previousCall as $previousCallsStructurePreviousCallItem) {
            // validation for constraint: itemType
            if (!$previousCallsStructurePreviousCallItem instanceof \StructType\PreviousCallStructure) {
                throw new \InvalidArgumentException(sprintf('The PreviousCall property can only contain items of \StructType\PreviousCallStructure, "%s" given', is_object($previousCallsStructurePreviousCallItem) ? get_class($previousCallsStructurePreviousCallItem) : gettype($previousCallsStructurePreviousCallItem)), __LINE__);
            }
        }
        $this->PreviousCall = $previousCall;
        return $this;
    }
    /**
     * Add item to PreviousCall value
     * @throws \InvalidArgumentException
     * @param \StructType\PreviousCallStructure $item
     * @return \StructType\PreviousCallsStructure
     */
    public function addToPreviousCall(\StructType\PreviousCallStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PreviousCallStructure) {
            throw new \InvalidArgumentException(sprintf('The PreviousCall property can only contain items of \StructType\PreviousCallStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PreviousCall[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreviousCallsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
