<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviousCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for CALL at previous stop.
 * @subpackage Structs
 */
class PreviousCallStructure extends AbstractMonitoredCallStructure
{
    /**
     * The VehicleAtStop
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: VehicleAtStop
     * @var bool
     */
    public $VehicleAtStop;
    /**
     * The AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ActualArrivalTime
     * @var string
     */
    public $ActualArrivalTime;
    /**
     * The ExpectedArrivalTime
     * @var string
     */
    public $ExpectedArrivalTime;
    /**
     * The AimedDepartureTime
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The ActualDepartureTime
     * @var string
     */
    public $ActualDepartureTime;
    /**
     * The ExpectedDepartureTime
     * @var string
     */
    public $ExpectedDepartureTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for PreviousCallStructure
     * @uses PreviousCallStructure::setVehicleAtStop()
     * @uses PreviousCallStructure::setAimedArrivalTime()
     * @uses PreviousCallStructure::setActualArrivalTime()
     * @uses PreviousCallStructure::setExpectedArrivalTime()
     * @uses PreviousCallStructure::setAimedDepartureTime()
     * @uses PreviousCallStructure::setActualDepartureTime()
     * @uses PreviousCallStructure::setExpectedDepartureTime()
     * @uses PreviousCallStructure::setExtensions()
     * @param bool $vehicleAtStop
     * @param string $aimedArrivalTime
     * @param string $actualArrivalTime
     * @param string $expectedArrivalTime
     * @param string $aimedDepartureTime
     * @param string $actualDepartureTime
     * @param string $expectedDepartureTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($vehicleAtStop = null, $aimedArrivalTime = null, $actualArrivalTime = null, $expectedArrivalTime = null, $aimedDepartureTime = null, $actualDepartureTime = null, $expectedDepartureTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVehicleAtStop($vehicleAtStop)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setActualArrivalTime($actualArrivalTime)
            ->setExpectedArrivalTime($expectedArrivalTime)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setActualDepartureTime($actualDepartureTime)
            ->setExpectedDepartureTime($expectedDepartureTime)
            ->setExtensions($extensions);
    }
    /**
     * Get VehicleAtStop value
     * @return bool|null
     */
    public function getVehicleAtStop()
    {
        return $this->VehicleAtStop;
    }
    /**
     * Set VehicleAtStop value
     * @param bool $vehicleAtStop
     * @return \StructType\PreviousCallStructure
     */
    public function setVehicleAtStop($vehicleAtStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($vehicleAtStop) && !is_bool($vehicleAtStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vehicleAtStop)), __LINE__);
        }
        $this->VehicleAtStop = $vehicleAtStop;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\PreviousCallStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ActualArrivalTime value
     * @return string|null
     */
    public function getActualArrivalTime()
    {
        return $this->ActualArrivalTime;
    }
    /**
     * Set ActualArrivalTime value
     * @param string $actualArrivalTime
     * @return \StructType\PreviousCallStructure
     */
    public function setActualArrivalTime($actualArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualArrivalTime) && !is_string($actualArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualArrivalTime)), __LINE__);
        }
        $this->ActualArrivalTime = $actualArrivalTime;
        return $this;
    }
    /**
     * Get ExpectedArrivalTime value
     * @return string|null
     */
    public function getExpectedArrivalTime()
    {
        return $this->ExpectedArrivalTime;
    }
    /**
     * Set ExpectedArrivalTime value
     * @param string $expectedArrivalTime
     * @return \StructType\PreviousCallStructure
     */
    public function setExpectedArrivalTime($expectedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedArrivalTime) && !is_string($expectedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedArrivalTime)), __LINE__);
        }
        $this->ExpectedArrivalTime = $expectedArrivalTime;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\PreviousCallStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get ActualDepartureTime value
     * @return string|null
     */
    public function getActualDepartureTime()
    {
        return $this->ActualDepartureTime;
    }
    /**
     * Set ActualDepartureTime value
     * @param string $actualDepartureTime
     * @return \StructType\PreviousCallStructure
     */
    public function setActualDepartureTime($actualDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepartureTime) && !is_string($actualDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDepartureTime)), __LINE__);
        }
        $this->ActualDepartureTime = $actualDepartureTime;
        return $this;
    }
    /**
     * Get ExpectedDepartureTime value
     * @return string|null
     */
    public function getExpectedDepartureTime()
    {
        return $this->ExpectedDepartureTime;
    }
    /**
     * Set ExpectedDepartureTime value
     * @param string $expectedDepartureTime
     * @return \StructType\PreviousCallStructure
     */
    public function setExpectedDepartureTime($expectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDepartureTime) && !is_string($expectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedDepartureTime)), __LINE__);
        }
        $this->ExpectedDepartureTime = $expectedDepartureTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\PreviousCallStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreviousCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
