<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PollutionInformation StructType
 * @subpackage Structs
 */
class PollutionInformation extends WeatherValue
{
    /**
     * The pollutionMeasurement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PollutionMeasurement[]
     */
    public $pollutionMeasurement;
    /**
     * The pollutionInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $pollutionInformationExtension;
    /**
     * Constructor method for PollutionInformation
     * @uses PollutionInformation::setPollutionMeasurement()
     * @uses PollutionInformation::setPollutionInformationExtension()
     * @param \StructType\PollutionMeasurement[] $pollutionMeasurement
     * @param \StructType\ExtensionType $pollutionInformationExtension
     */
    public function __construct(array $pollutionMeasurement = array(), \StructType\ExtensionType $pollutionInformationExtension = null)
    {
        $this
            ->setPollutionMeasurement($pollutionMeasurement)
            ->setPollutionInformationExtension($pollutionInformationExtension);
    }
    /**
     * Get pollutionMeasurement value
     * @return \StructType\PollutionMeasurement[]|null
     */
    public function getPollutionMeasurement()
    {
        return $this->pollutionMeasurement;
    }
    /**
     * Set pollutionMeasurement value
     * @throws \InvalidArgumentException
     * @param \StructType\PollutionMeasurement[] $pollutionMeasurement
     * @return \StructType\PollutionInformation
     */
    public function setPollutionMeasurement(array $pollutionMeasurement = array())
    {
        foreach ($pollutionMeasurement as $pollutionInformationPollutionMeasurementItem) {
            // validation for constraint: itemType
            if (!$pollutionInformationPollutionMeasurementItem instanceof \StructType\PollutionMeasurement) {
                throw new \InvalidArgumentException(sprintf('The pollutionMeasurement property can only contain items of \StructType\PollutionMeasurement, "%s" given', is_object($pollutionInformationPollutionMeasurementItem) ? get_class($pollutionInformationPollutionMeasurementItem) : gettype($pollutionInformationPollutionMeasurementItem)), __LINE__);
            }
        }
        $this->pollutionMeasurement = $pollutionMeasurement;
        return $this;
    }
    /**
     * Add item to pollutionMeasurement value
     * @throws \InvalidArgumentException
     * @param \StructType\PollutionMeasurement $item
     * @return \StructType\PollutionInformation
     */
    public function addToPollutionMeasurement(\StructType\PollutionMeasurement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PollutionMeasurement) {
            throw new \InvalidArgumentException(sprintf('The pollutionMeasurement property can only contain items of \StructType\PollutionMeasurement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pollutionMeasurement[] = $item;
        return $this;
    }
    /**
     * Get pollutionInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPollutionInformationExtension()
    {
        return $this->pollutionInformationExtension;
    }
    /**
     * Set pollutionInformationExtension value
     * @param \StructType\ExtensionType $pollutionInformationExtension
     * @return \StructType\PollutionInformation
     */
    public function setPollutionInformationExtension(\StructType\ExtensionType $pollutionInformationExtension = null)
    {
        $this->pollutionInformationExtension = $pollutionInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollutionInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
