<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointProjectionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for geospatial Position of a point. May be expressed in concrete WGS 84 Coordinates or any GML compatible point coordinates format. | WGS84 Corodinates.
 * @subpackage Structs
 */
class PointProjectionStructure extends AbstractProjection
{
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - documentation: Longitude from Greenwich.
     * - maxInclusive: 180
     * - minInclusive: -180
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - documentation: Latitude from equator.
     * - maxInclusive: 90
     * - minInclusive: -90
     * @var float
     */
    public $Latitude;
    /**
     * The Altitude
     * Meta informations extracted from the WSDL
     * - documentation: Altitude metres from sea level.
     * - maxInclusive: +5000
     * - minInclusive: -1000
     * @var float
     */
    public $Altitude;
    /**
     * The Coordinates
     * Meta informations extracted from the WSDL
     * - documentation: Coordinates of points in a GML compatible format, as indicated by srsName attribute.
     * - minOccurs: 0
     * @var \StructType\CoordinatesStructure
     */
    public $Coordinates;
    /**
     * The Precision
     * Meta informations extracted from the WSDL
     * - documentation: Precision for point measurement. In meters. | Distance (metres) as defined by http://www.ordnancesurvey.co.uk/xml/resource/units.xml#metres. ALternative units may be specifed by context.
     * - minOccurs: 0
     * @var int
     */
    public $Precision;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of POINT.
     * @var string
     */
    public $id;
    /**
     * The srsName
     * Meta informations extracted from the WSDL
     * - documentation: identifier of data reference system for geocodes, if point is specified as GML compatible Coordinates. A GML value. If not specified taken from system configuration. | Type for coordinate reference system.
     * @var string
     */
    public $srsName;
    /**
     * Constructor method for PointProjectionStructure
     * @uses PointProjectionStructure::setLongitude()
     * @uses PointProjectionStructure::setLatitude()
     * @uses PointProjectionStructure::setAltitude()
     * @uses PointProjectionStructure::setCoordinates()
     * @uses PointProjectionStructure::setPrecision()
     * @uses PointProjectionStructure::setId()
     * @uses PointProjectionStructure::setSrsName()
     * @param float $longitude
     * @param float $latitude
     * @param float $altitude
     * @param \StructType\CoordinatesStructure $coordinates
     * @param int $precision
     * @param string $id
     * @param string $srsName
     */
    public function __construct($longitude = null, $latitude = null, $altitude = null, \StructType\CoordinatesStructure $coordinates = null, $precision = null, $id = null, $srsName = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setAltitude($altitude)
            ->setCoordinates($coordinates)
            ->setPrecision($precision)
            ->setId($id)
            ->setSrsName($srsName);
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\PointProjectionStructure
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: maxInclusive
        if ($longitude > 180) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 180, "%s" given', $longitude), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($longitude < -180) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -180, "%s" given', $longitude), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\PointProjectionStructure
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: maxInclusive
        if ($latitude > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 90, "%s" given', $latitude), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($latitude < -90) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -90, "%s" given', $latitude), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return float|null
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param float $altitude
     * @return \StructType\PointProjectionStructure
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: maxInclusive
        if ($altitude > 5000) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 5000, "%s" given', $altitude), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($altitude < -1000) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -1000, "%s" given', $altitude), __LINE__);
        }
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Get Coordinates value
     * @return \StructType\CoordinatesStructure|null
     */
    public function getCoordinates()
    {
        return $this->Coordinates;
    }
    /**
     * Set Coordinates value
     * @param \StructType\CoordinatesStructure $coordinates
     * @return \StructType\PointProjectionStructure
     */
    public function setCoordinates(\StructType\CoordinatesStructure $coordinates = null)
    {
        $this->Coordinates = $coordinates;
        return $this;
    }
    /**
     * Get Precision value
     * @return int|null
     */
    public function getPrecision()
    {
        return $this->Precision;
    }
    /**
     * Set Precision value
     * @param int $precision
     * @return \StructType\PointProjectionStructure
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !is_numeric($precision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($precision)), __LINE__);
        }
        $this->Precision = $precision;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\PointProjectionStructure
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get srsName value
     * @return string|null
     */
    public function getSrsName()
    {
        return $this->srsName;
    }
    /**
     * Set srsName value
     * @param string $srsName
     * @return \StructType\PointProjectionStructure
     */
    public function setSrsName($srsName = null)
    {
        // validation for constraint: string
        if (!is_null($srsName) && !is_string($srsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srsName)), __LINE__);
        }
        $this->srsName = $srsName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PointProjectionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
