<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointCoordinates StructType
 * @subpackage Structs
 */
class PointCoordinates extends AbstractStructBase
{
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The pointCoordinatesExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $pointCoordinatesExtension;
    /**
     * Constructor method for PointCoordinates
     * @uses PointCoordinates::setLatitude()
     * @uses PointCoordinates::setLongitude()
     * @uses PointCoordinates::setPointCoordinatesExtension()
     * @param float $latitude
     * @param float $longitude
     * @param \StructType\ExtensionType $pointCoordinatesExtension
     */
    public function __construct($latitude = null, $longitude = null, \StructType\ExtensionType $pointCoordinatesExtension = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setPointCoordinatesExtension($pointCoordinatesExtension);
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\PointCoordinates
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\PointCoordinates
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get pointCoordinatesExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPointCoordinatesExtension()
    {
        return $this->pointCoordinatesExtension;
    }
    /**
     * Set pointCoordinatesExtension value
     * @param \StructType\ExtensionType $pointCoordinatesExtension
     * @return \StructType\PointCoordinates
     */
    public function setPointCoordinatesExtension(\StructType\ExtensionType $pointCoordinatesExtension = null)
    {
        $this->pointCoordinatesExtension = $pointCoordinatesExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PointCoordinates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
