<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointByCoordinates StructType
 * @subpackage Structs
 */
class PointByCoordinates extends AbstractStructBase
{
    /**
     * The bearing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $bearing;
    /**
     * The pointCoordinates
     * @var \StructType\PointCoordinates
     */
    public $pointCoordinates;
    /**
     * The pointByCoordinatesExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $pointByCoordinatesExtension;
    /**
     * Constructor method for PointByCoordinates
     * @uses PointByCoordinates::setBearing()
     * @uses PointByCoordinates::setPointCoordinates()
     * @uses PointByCoordinates::setPointByCoordinatesExtension()
     * @param int $bearing
     * @param \StructType\PointCoordinates $pointCoordinates
     * @param \StructType\ExtensionType $pointByCoordinatesExtension
     */
    public function __construct($bearing = null, \StructType\PointCoordinates $pointCoordinates = null, \StructType\ExtensionType $pointByCoordinatesExtension = null)
    {
        $this
            ->setBearing($bearing)
            ->setPointCoordinates($pointCoordinates)
            ->setPointByCoordinatesExtension($pointByCoordinatesExtension);
    }
    /**
     * Get bearing value
     * @return int|null
     */
    public function getBearing()
    {
        return $this->bearing;
    }
    /**
     * Set bearing value
     * @param int $bearing
     * @return \StructType\PointByCoordinates
     */
    public function setBearing($bearing = null)
    {
        // validation for constraint: int
        if (!is_null($bearing) && !is_numeric($bearing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bearing)), __LINE__);
        }
        $this->bearing = $bearing;
        return $this;
    }
    /**
     * Get pointCoordinates value
     * @return \StructType\PointCoordinates|null
     */
    public function getPointCoordinates()
    {
        return $this->pointCoordinates;
    }
    /**
     * Set pointCoordinates value
     * @param \StructType\PointCoordinates $pointCoordinates
     * @return \StructType\PointByCoordinates
     */
    public function setPointCoordinates(\StructType\PointCoordinates $pointCoordinates = null)
    {
        $this->pointCoordinates = $pointCoordinates;
        return $this;
    }
    /**
     * Get pointByCoordinatesExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPointByCoordinatesExtension()
    {
        return $this->pointByCoordinatesExtension;
    }
    /**
     * Set pointByCoordinatesExtension value
     * @param \StructType\ExtensionType $pointByCoordinatesExtension
     * @return \StructType\PointByCoordinates
     */
    public function setPointByCoordinatesExtension(\StructType\ExtensionType $pointByCoordinatesExtension = null)
    {
        $this->pointByCoordinatesExtension = $pointByCoordinatesExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PointByCoordinates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
