<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayloadPublication StructType
 * @subpackage Structs
 */
abstract class PayloadPublication extends AbstractStructBase
{
    /**
     * The publicationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $publicationTime;
    /**
     * The lang
     * Meta informations extracted from the WSDL
     * - use: required
     * - default: en
     * - documentation: Preferred language in which to return text values. | Preferred language in which to return text values. | Preferred language in which to return text values. | Preferred language in which to return text values. | Preferred language in
     * which to return text values. | Preferred language in which to return text values. | Preferred language in which to return text values. | Preferred language in which to return text values. | Preferred language in which to return text values. |
     * Preferred language in which to return text values. | Preferred language in which to return text values. | Preferred language in which to return text values. +SIRI v2.0 | Preferred language in which to return text values. +SIRI v2.0 | Preferred
     * language in which to return text values. +SIRI v2.0 | Preferred language in which to return text values. +SIRI v2.0 | Preferred language in which to return text values. +SIRI v2.0 | Preferred language in which to return text values. +SIRI v2.0 |
     * Default language.
     * - minOccurs: 0
     * - type: xsd:NMTOKEN
     * @var string
     */
    public $lang;
    /**
     * The feedDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $feedDescription;
    /**
     * The feedType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $feedType;
    /**
     * The publicationCreator
     * @var \StructType\InternationalIdentifier
     */
    public $publicationCreator;
    /**
     * The payloadPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $payloadPublicationExtension;
    /**
     * Constructor method for PayloadPublication
     * @uses PayloadPublication::setPublicationTime()
     * @uses PayloadPublication::setLang()
     * @uses PayloadPublication::setFeedDescription()
     * @uses PayloadPublication::setFeedType()
     * @uses PayloadPublication::setPublicationCreator()
     * @uses PayloadPublication::setPayloadPublicationExtension()
     * @param string $publicationTime
     * @param string $lang
     * @param \StructType\MultilingualString $feedDescription
     * @param string $feedType
     * @param \StructType\InternationalIdentifier $publicationCreator
     * @param \StructType\ExtensionType $payloadPublicationExtension
     */
    public function __construct($publicationTime = null, $lang = 'en', \StructType\MultilingualString $feedDescription = null, $feedType = null, \StructType\InternationalIdentifier $publicationCreator = null, \StructType\ExtensionType $payloadPublicationExtension = null)
    {
        $this
            ->setPublicationTime($publicationTime)
            ->setLang($lang)
            ->setFeedDescription($feedDescription)
            ->setFeedType($feedType)
            ->setPublicationCreator($publicationCreator)
            ->setPayloadPublicationExtension($payloadPublicationExtension);
    }
    /**
     * Get publicationTime value
     * @return string
     */
    public function getPublicationTime()
    {
        return $this->publicationTime;
    }
    /**
     * Set publicationTime value
     * @param string $publicationTime
     * @return \StructType\PayloadPublication
     */
    public function setPublicationTime($publicationTime = null)
    {
        // validation for constraint: string
        if (!is_null($publicationTime) && !is_string($publicationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($publicationTime)), __LINE__);
        }
        $this->publicationTime = $publicationTime;
        return $this;
    }
    /**
     * Get lang value
     * @return string
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\PayloadPublication
     */
    public function setLang($lang = 'en')
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get feedDescription value
     * @return \StructType\MultilingualString|null
     */
    public function getFeedDescription()
    {
        return $this->feedDescription;
    }
    /**
     * Set feedDescription value
     * @param \StructType\MultilingualString $feedDescription
     * @return \StructType\PayloadPublication
     */
    public function setFeedDescription(\StructType\MultilingualString $feedDescription = null)
    {
        $this->feedDescription = $feedDescription;
        return $this;
    }
    /**
     * Get feedType value
     * @return string|null
     */
    public function getFeedType()
    {
        return $this->feedType;
    }
    /**
     * Set feedType value
     * @param string $feedType
     * @return \StructType\PayloadPublication
     */
    public function setFeedType($feedType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($feedType) && strlen($feedType) > 1024) || (is_array($feedType) && count($feedType) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($feedType) ? strlen($feedType) : count($feedType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($feedType) && !is_string($feedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedType)), __LINE__);
        }
        $this->feedType = $feedType;
        return $this;
    }
    /**
     * Get publicationCreator value
     * @return \StructType\InternationalIdentifier|null
     */
    public function getPublicationCreator()
    {
        return $this->publicationCreator;
    }
    /**
     * Set publicationCreator value
     * @param \StructType\InternationalIdentifier $publicationCreator
     * @return \StructType\PayloadPublication
     */
    public function setPublicationCreator(\StructType\InternationalIdentifier $publicationCreator = null)
    {
        $this->publicationCreator = $publicationCreator;
        return $this;
    }
    /**
     * Get payloadPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPayloadPublicationExtension()
    {
        return $this->payloadPublicationExtension;
    }
    /**
     * Set payloadPublicationExtension value
     * @param \StructType\ExtensionType $payloadPublicationExtension
     * @return \StructType\PayloadPublication
     */
    public function setPayloadPublicationExtension(\StructType\ExtensionType $payloadPublicationExtension = null)
    {
        $this->payloadPublicationExtension = $payloadPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayloadPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
