<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterisedActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for parameterised, i.e. user definable, actions.
 * @subpackage Structs
 */
class ParameterisedActionStructure extends SimpleActionStructure
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Description of action.
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $Description;
    /**
     * The ActionData
     * Meta informations extracted from the WSDL
     * - documentation: Data associated with action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActionDataStructure[]
     */
    public $ActionData;
    /**
     * Constructor method for ParameterisedActionStructure
     * @uses ParameterisedActionStructure::setDescription()
     * @uses ParameterisedActionStructure::setActionData()
     * @param \StructType\NaturalLanguageStringStructure $description
     * @param \StructType\ActionDataStructure[] $actionData
     */
    public function __construct(\StructType\NaturalLanguageStringStructure $description = null, array $actionData = array())
    {
        $this
            ->setDescription($description)
            ->setActionData($actionData);
    }
    /**
     * Get Description value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\NaturalLanguageStringStructure $description
     * @return \StructType\ParameterisedActionStructure
     */
    public function setDescription(\StructType\NaturalLanguageStringStructure $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ActionData value
     * @return \StructType\ActionDataStructure[]|null
     */
    public function getActionData()
    {
        return $this->ActionData;
    }
    /**
     * Set ActionData value
     * @throws \InvalidArgumentException
     * @param \StructType\ActionDataStructure[] $actionData
     * @return \StructType\ParameterisedActionStructure
     */
    public function setActionData(array $actionData = array())
    {
        foreach ($actionData as $parameterisedActionStructureActionDataItem) {
            // validation for constraint: itemType
            if (!$parameterisedActionStructureActionDataItem instanceof \StructType\ActionDataStructure) {
                throw new \InvalidArgumentException(sprintf('The ActionData property can only contain items of \StructType\ActionDataStructure, "%s" given', is_object($parameterisedActionStructureActionDataItem) ? get_class($parameterisedActionStructureActionDataItem) : gettype($parameterisedActionStructureActionDataItem)), __LINE__);
            }
        }
        $this->ActionData = $actionData;
        return $this;
    }
    /**
     * Add item to ActionData value
     * @throws \InvalidArgumentException
     * @param \StructType\ActionDataStructure $item
     * @return \StructType\ParameterisedActionStructure
     */
    public function addToActionData(\StructType\ActionDataStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActionDataStructure) {
            throw new \InvalidArgumentException(sprintf('The ActionData property can only contain items of \StructType\ActionDataStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActionData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParameterisedActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
