<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverallPeriod StructType
 * @subpackage Structs
 */
class OverallPeriod extends AbstractStructBase
{
    /**
     * The overallStartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $overallStartTime;
    /**
     * The overallEndTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $overallEndTime;
    /**
     * The validPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Period[]
     */
    public $validPeriod;
    /**
     * The exceptionPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Period[]
     */
    public $exceptionPeriod;
    /**
     * The overallPeriodExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $overallPeriodExtension;
    /**
     * Constructor method for OverallPeriod
     * @uses OverallPeriod::setOverallStartTime()
     * @uses OverallPeriod::setOverallEndTime()
     * @uses OverallPeriod::setValidPeriod()
     * @uses OverallPeriod::setExceptionPeriod()
     * @uses OverallPeriod::setOverallPeriodExtension()
     * @param string $overallStartTime
     * @param string $overallEndTime
     * @param \StructType\Period[] $validPeriod
     * @param \StructType\Period[] $exceptionPeriod
     * @param \StructType\ExtensionType $overallPeriodExtension
     */
    public function __construct($overallStartTime = null, $overallEndTime = null, array $validPeriod = array(), array $exceptionPeriod = array(), \StructType\ExtensionType $overallPeriodExtension = null)
    {
        $this
            ->setOverallStartTime($overallStartTime)
            ->setOverallEndTime($overallEndTime)
            ->setValidPeriod($validPeriod)
            ->setExceptionPeriod($exceptionPeriod)
            ->setOverallPeriodExtension($overallPeriodExtension);
    }
    /**
     * Get overallStartTime value
     * @return string
     */
    public function getOverallStartTime()
    {
        return $this->overallStartTime;
    }
    /**
     * Set overallStartTime value
     * @param string $overallStartTime
     * @return \StructType\OverallPeriod
     */
    public function setOverallStartTime($overallStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($overallStartTime) && !is_string($overallStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStartTime)), __LINE__);
        }
        $this->overallStartTime = $overallStartTime;
        return $this;
    }
    /**
     * Get overallEndTime value
     * @return string|null
     */
    public function getOverallEndTime()
    {
        return $this->overallEndTime;
    }
    /**
     * Set overallEndTime value
     * @param string $overallEndTime
     * @return \StructType\OverallPeriod
     */
    public function setOverallEndTime($overallEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($overallEndTime) && !is_string($overallEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallEndTime)), __LINE__);
        }
        $this->overallEndTime = $overallEndTime;
        return $this;
    }
    /**
     * Get validPeriod value
     * @return \StructType\Period[]|null
     */
    public function getValidPeriod()
    {
        return $this->validPeriod;
    }
    /**
     * Set validPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\Period[] $validPeriod
     * @return \StructType\OverallPeriod
     */
    public function setValidPeriod(array $validPeriod = array())
    {
        foreach ($validPeriod as $overallPeriodValidPeriodItem) {
            // validation for constraint: itemType
            if (!$overallPeriodValidPeriodItem instanceof \StructType\Period) {
                throw new \InvalidArgumentException(sprintf('The validPeriod property can only contain items of \StructType\Period, "%s" given', is_object($overallPeriodValidPeriodItem) ? get_class($overallPeriodValidPeriodItem) : gettype($overallPeriodValidPeriodItem)), __LINE__);
            }
        }
        $this->validPeriod = $validPeriod;
        return $this;
    }
    /**
     * Add item to validPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\Period $item
     * @return \StructType\OverallPeriod
     */
    public function addToValidPeriod(\StructType\Period $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Period) {
            throw new \InvalidArgumentException(sprintf('The validPeriod property can only contain items of \StructType\Period, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->validPeriod[] = $item;
        return $this;
    }
    /**
     * Get exceptionPeriod value
     * @return \StructType\Period[]|null
     */
    public function getExceptionPeriod()
    {
        return $this->exceptionPeriod;
    }
    /**
     * Set exceptionPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\Period[] $exceptionPeriod
     * @return \StructType\OverallPeriod
     */
    public function setExceptionPeriod(array $exceptionPeriod = array())
    {
        foreach ($exceptionPeriod as $overallPeriodExceptionPeriodItem) {
            // validation for constraint: itemType
            if (!$overallPeriodExceptionPeriodItem instanceof \StructType\Period) {
                throw new \InvalidArgumentException(sprintf('The exceptionPeriod property can only contain items of \StructType\Period, "%s" given', is_object($overallPeriodExceptionPeriodItem) ? get_class($overallPeriodExceptionPeriodItem) : gettype($overallPeriodExceptionPeriodItem)), __LINE__);
            }
        }
        $this->exceptionPeriod = $exceptionPeriod;
        return $this;
    }
    /**
     * Add item to exceptionPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\Period $item
     * @return \StructType\OverallPeriod
     */
    public function addToExceptionPeriod(\StructType\Period $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Period) {
            throw new \InvalidArgumentException(sprintf('The exceptionPeriod property can only contain items of \StructType\Period, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->exceptionPeriod[] = $item;
        return $this;
    }
    /**
     * Get overallPeriodExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getOverallPeriodExtension()
    {
        return $this->overallPeriodExtension;
    }
    /**
     * Set overallPeriodExtension value
     * @param \StructType\ExtensionType $overallPeriodExtension
     * @return \StructType\OverallPeriod
     */
    public function setOverallPeriodExtension(\StructType\ExtensionType $overallPeriodExtension = null)
    {
        $this->overallPeriodExtension = $overallPeriodExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OverallPeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
