<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffsetStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the LINEs affected by a SITUATION.
 * @subpackage Structs
 */
class OffsetStructure extends AbstractStructBase
{
    /**
     * The DistanceFromStart
     * Meta informations extracted from the WSDL
     * - documentation: Distance in metres from start of link at which SITUATION is to be shown. I f absent use start of link.
     * - minOccurs: 0
     * @var int
     */
    public $DistanceFromStart;
    /**
     * The DistanceFromEnd
     * Meta informations extracted from the WSDL
     * - documentation: Distance in metres from end of link at which SITUATION is to be shown. I f absent use end of link.
     * - minOccurs: 0
     * @var int
     */
    public $DistanceFromEnd;
    /**
     * Constructor method for OffsetStructure
     * @uses OffsetStructure::setDistanceFromStart()
     * @uses OffsetStructure::setDistanceFromEnd()
     * @param int $distanceFromStart
     * @param int $distanceFromEnd
     */
    public function __construct($distanceFromStart = null, $distanceFromEnd = null)
    {
        $this
            ->setDistanceFromStart($distanceFromStart)
            ->setDistanceFromEnd($distanceFromEnd);
    }
    /**
     * Get DistanceFromStart value
     * @return int|null
     */
    public function getDistanceFromStart()
    {
        return $this->DistanceFromStart;
    }
    /**
     * Set DistanceFromStart value
     * @param int $distanceFromStart
     * @return \StructType\OffsetStructure
     */
    public function setDistanceFromStart($distanceFromStart = null)
    {
        // validation for constraint: int
        if (!is_null($distanceFromStart) && !is_numeric($distanceFromStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distanceFromStart)), __LINE__);
        }
        $this->DistanceFromStart = $distanceFromStart;
        return $this;
    }
    /**
     * Get DistanceFromEnd value
     * @return int|null
     */
    public function getDistanceFromEnd()
    {
        return $this->DistanceFromEnd;
    }
    /**
     * Set DistanceFromEnd value
     * @param int $distanceFromEnd
     * @return \StructType\OffsetStructure
     */
    public function setDistanceFromEnd($distanceFromEnd = null)
    {
        // validation for constraint: int
        if (!is_null($distanceFromEnd) && !is_numeric($distanceFromEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distanceFromEnd)), __LINE__);
        }
        $this->DistanceFromEnd = $distanceFromEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffsetStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
