<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyByPagerActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notify user by Pager.
 * @subpackage Structs
 */
class NotifyByPagerActionStructure extends PushedActionStructure
{
    /**
     * The PagerGroupRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a pager group to be notfied.
     * - minOccurs: 0
     * @var string
     */
    public $PagerGroupRef;
    /**
     * The Pager
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Pager number of pager to be notfied.
     * - minOccurs: 0
     * @var string
     */
    public $Pager;
    /**
     * Constructor method for NotifyByPagerActionStructure
     * @uses NotifyByPagerActionStructure::setPagerGroupRef()
     * @uses NotifyByPagerActionStructure::setPager()
     * @param string $pagerGroupRef
     * @param string $pager
     */
    public function __construct($pagerGroupRef = null, $pager = 'true')
    {
        $this
            ->setPagerGroupRef($pagerGroupRef)
            ->setPager($pager);
    }
    /**
     * Get PagerGroupRef value
     * @return string|null
     */
    public function getPagerGroupRef()
    {
        return $this->PagerGroupRef;
    }
    /**
     * Set PagerGroupRef value
     * @param string $pagerGroupRef
     * @return \StructType\NotifyByPagerActionStructure
     */
    public function setPagerGroupRef($pagerGroupRef = null)
    {
        // validation for constraint: string
        if (!is_null($pagerGroupRef) && !is_string($pagerGroupRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pagerGroupRef)), __LINE__);
        }
        $this->PagerGroupRef = $pagerGroupRef;
        return $this;
    }
    /**
     * Get Pager value
     * @return string|null
     */
    public function getPager()
    {
        return $this->Pager;
    }
    /**
     * Set Pager value
     * @param string $pager
     * @return \StructType\NotifyByPagerActionStructure
     */
    public function setPager($pager = 'true')
    {
        // validation for constraint: string
        if (!is_null($pager) && !is_string($pager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pager)), __LINE__);
        }
        $this->Pager = $pager;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NotifyByPagerActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
