<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkLocation StructType
 * @subpackage Structs
 */
abstract class NetworkLocation extends Location
{
    /**
     * The supplementaryPositionalDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SupplementaryPositionalDescription
     */
    public $supplementaryPositionalDescription;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Destination
     */
    public $destination;
    /**
     * The networkLocationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $networkLocationExtension;
    /**
     * Constructor method for NetworkLocation
     * @uses NetworkLocation::setSupplementaryPositionalDescription()
     * @uses NetworkLocation::setDestination()
     * @uses NetworkLocation::setNetworkLocationExtension()
     * @param \StructType\SupplementaryPositionalDescription $supplementaryPositionalDescription
     * @param \StructType\Destination $destination
     * @param \StructType\ExtensionType $networkLocationExtension
     */
    public function __construct(\StructType\SupplementaryPositionalDescription $supplementaryPositionalDescription = null, \StructType\Destination $destination = null, \StructType\ExtensionType $networkLocationExtension = null)
    {
        $this
            ->setSupplementaryPositionalDescription($supplementaryPositionalDescription)
            ->setDestination($destination)
            ->setNetworkLocationExtension($networkLocationExtension);
    }
    /**
     * Get supplementaryPositionalDescription value
     * @return \StructType\SupplementaryPositionalDescription|null
     */
    public function getSupplementaryPositionalDescription()
    {
        return $this->supplementaryPositionalDescription;
    }
    /**
     * Set supplementaryPositionalDescription value
     * @param \StructType\SupplementaryPositionalDescription $supplementaryPositionalDescription
     * @return \StructType\NetworkLocation
     */
    public function setSupplementaryPositionalDescription(\StructType\SupplementaryPositionalDescription $supplementaryPositionalDescription = null)
    {
        $this->supplementaryPositionalDescription = $supplementaryPositionalDescription;
        return $this;
    }
    /**
     * Get destination value
     * @return \StructType\Destination|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \StructType\Destination $destination
     * @return \StructType\NetworkLocation
     */
    public function setDestination(\StructType\Destination $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get networkLocationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getNetworkLocationExtension()
    {
        return $this->networkLocationExtension;
    }
    /**
     * Set networkLocationExtension value
     * @param \StructType\ExtensionType $networkLocationExtension
     * @return \StructType\NetworkLocation
     */
    public function setNetworkLocationExtension(\StructType\ExtensionType $networkLocationExtension = null)
    {
        $this->networkLocationExtension = $networkLocationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NetworkLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
