<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaturalLanguagePlaceNameStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: @lang. ISO language code (default is 'en')A string containing a phrase in a natural language name that requires at least one character of text and forbids certain reserved characters. | A name that requires at least one character of
 * text and forbids certain reserved characters. | A restriction of W3C XML Schema's string that requires at least one character of text.
 * - pattern: [^,\[\]\{\}\?$%\^=@#;:]+
 * - minLength: 1
 * @subpackage Structs
 */
class NaturalLanguagePlaceNameStructure extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: A name that requires at least one character of text and forbids certain reserved characters. | A restriction of W3C XML Schema's string that requires at least one character of text.
     * - pattern: [^,\[\]\{\}\?$%\^=@#;:]+
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The lang
     * Meta informations extracted from the WSDL
     * - ref: xml:lang
     * - use: optional
     * @var string
     */
    public $lang;
    /**
     * Constructor method for NaturalLanguagePlaceNameStructure
     * @uses NaturalLanguagePlaceNameStructure::set_()
     * @uses NaturalLanguagePlaceNameStructure::setLang()
     * @param string $_
     * @param string $lang
     */
    public function __construct($_ = null, $lang = null)
    {
        $this
            ->set_($_)
            ->setLang($lang);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\NaturalLanguagePlaceNameStructure
     */
    public function set_($_ = null)
    {
        // validation for constraint: pattern
        if (is_scalar($_) && !preg_match('/[^,\\[\\]\\{\\}\\?$%\\^=@#;:]+/', $_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^,\[\]\{\}\?$%\^=@#;:]+", "%s" given', var_export($_, true)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 1) || (is_array($_) && count($_) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\NaturalLanguagePlaceNameStructure
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NaturalLanguagePlaceNameStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
