<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonitoringValidityConditionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for the type for Description of the monitoring conditions (frequency of mesurement, etc): an automatic monitoring of the satus of a lift with pushed alert in case of incident is very different from a daily
 * manual/visual check.
 * @subpackage Structs
 */
class MonitoringValidityConditionStructure extends AbstractStructBase
{
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - documentation: Date and tme range within which condition is available.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HalfOpenTimestampOutputRangeStructure[]
     */
    public $Period;
    /**
     * The Timeband
     * Meta informations extracted from the WSDL
     * - documentation: Monitoring period within a single day (monitoring may not be available at night, or may ony occur at certain time of day for manual monitoring, etc.). Several periods can be defined.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HalfOpenTimeRangeStructure[]
     */
    public $Timeband;
    /**
     * The DayType
     * Meta informations extracted from the WSDL
     * - documentation: Days type for monitoring availability.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DayType;
    /**
     * The HolidayType
     * Meta informations extracted from the WSDL
     * - documentation: Holiday type for monitoring availability.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $HolidayType;
    /**
     * Constructor method for MonitoringValidityConditionStructure
     * @uses MonitoringValidityConditionStructure::setPeriod()
     * @uses MonitoringValidityConditionStructure::setTimeband()
     * @uses MonitoringValidityConditionStructure::setDayType()
     * @uses MonitoringValidityConditionStructure::setHolidayType()
     * @param \StructType\HalfOpenTimestampOutputRangeStructure[] $period
     * @param \StructType\HalfOpenTimeRangeStructure[] $timeband
     * @param string[] $dayType
     * @param string[] $holidayType
     */
    public function __construct(array $period = array(), array $timeband = array(), array $dayType = array(), array $holidayType = array())
    {
        $this
            ->setPeriod($period)
            ->setTimeband($timeband)
            ->setDayType($dayType)
            ->setHolidayType($holidayType);
    }
    /**
     * Get Period value
     * @return \StructType\HalfOpenTimestampOutputRangeStructure[]|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @throws \InvalidArgumentException
     * @param \StructType\HalfOpenTimestampOutputRangeStructure[] $period
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function setPeriod(array $period = array())
    {
        foreach ($period as $monitoringValidityConditionStructurePeriodItem) {
            // validation for constraint: itemType
            if (!$monitoringValidityConditionStructurePeriodItem instanceof \StructType\HalfOpenTimestampOutputRangeStructure) {
                throw new \InvalidArgumentException(sprintf('The Period property can only contain items of \StructType\HalfOpenTimestampOutputRangeStructure, "%s" given', is_object($monitoringValidityConditionStructurePeriodItem) ? get_class($monitoringValidityConditionStructurePeriodItem) : gettype($monitoringValidityConditionStructurePeriodItem)), __LINE__);
            }
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Add item to Period value
     * @throws \InvalidArgumentException
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $item
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function addToPeriod(\StructType\HalfOpenTimestampOutputRangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HalfOpenTimestampOutputRangeStructure) {
            throw new \InvalidArgumentException(sprintf('The Period property can only contain items of \StructType\HalfOpenTimestampOutputRangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Period[] = $item;
        return $this;
    }
    /**
     * Get Timeband value
     * @return \StructType\HalfOpenTimeRangeStructure[]|null
     */
    public function getTimeband()
    {
        return $this->Timeband;
    }
    /**
     * Set Timeband value
     * @throws \InvalidArgumentException
     * @param \StructType\HalfOpenTimeRangeStructure[] $timeband
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function setTimeband(array $timeband = array())
    {
        foreach ($timeband as $monitoringValidityConditionStructureTimebandItem) {
            // validation for constraint: itemType
            if (!$monitoringValidityConditionStructureTimebandItem instanceof \StructType\HalfOpenTimeRangeStructure) {
                throw new \InvalidArgumentException(sprintf('The Timeband property can only contain items of \StructType\HalfOpenTimeRangeStructure, "%s" given', is_object($monitoringValidityConditionStructureTimebandItem) ? get_class($monitoringValidityConditionStructureTimebandItem) : gettype($monitoringValidityConditionStructureTimebandItem)), __LINE__);
            }
        }
        $this->Timeband = $timeband;
        return $this;
    }
    /**
     * Add item to Timeband value
     * @throws \InvalidArgumentException
     * @param \StructType\HalfOpenTimeRangeStructure $item
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function addToTimeband(\StructType\HalfOpenTimeRangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HalfOpenTimeRangeStructure) {
            throw new \InvalidArgumentException(sprintf('The Timeband property can only contain items of \StructType\HalfOpenTimeRangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Timeband[] = $item;
        return $this;
    }
    /**
     * Get DayType value
     * @return string[]|null
     */
    public function getDayType()
    {
        return $this->DayType;
    }
    /**
     * Set DayType value
     * @uses \EnumType\DaysOfWeekEnumerationx::valueIsValid()
     * @uses \EnumType\DaysOfWeekEnumerationx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $dayType
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function setDayType(array $dayType = array())
    {
        $invalidValues = array();
        foreach ($dayType as $monitoringValidityConditionStructureDayTypeItem) {
            if (!\EnumType\DaysOfWeekEnumerationx::valueIsValid($monitoringValidityConditionStructureDayTypeItem)) {
                $invalidValues[] = var_export($monitoringValidityConditionStructureDayTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\DaysOfWeekEnumerationx::getValidValues())), __LINE__);
        }
        $this->DayType = $dayType;
        return $this;
    }
    /**
     * Add item to DayType value
     * @uses \EnumType\DaysOfWeekEnumerationx::valueIsValid()
     * @uses \EnumType\DaysOfWeekEnumerationx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function addToDayType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DaysOfWeekEnumerationx::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\DaysOfWeekEnumerationx::getValidValues())), __LINE__);
        }
        $this->DayType[] = $item;
        return $this;
    }
    /**
     * Get HolidayType value
     * @return string[]|null
     */
    public function getHolidayType()
    {
        return $this->HolidayType;
    }
    /**
     * Set HolidayType value
     * @uses \EnumType\HolidayTypeEnumerationx::valueIsValid()
     * @uses \EnumType\HolidayTypeEnumerationx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $holidayType
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function setHolidayType(array $holidayType = array())
    {
        $invalidValues = array();
        foreach ($holidayType as $monitoringValidityConditionStructureHolidayTypeItem) {
            if (!\EnumType\HolidayTypeEnumerationx::valueIsValid($monitoringValidityConditionStructureHolidayTypeItem)) {
                $invalidValues[] = var_export($monitoringValidityConditionStructureHolidayTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\HolidayTypeEnumerationx::getValidValues())), __LINE__);
        }
        $this->HolidayType = $holidayType;
        return $this;
    }
    /**
     * Add item to HolidayType value
     * @uses \EnumType\HolidayTypeEnumerationx::valueIsValid()
     * @uses \EnumType\HolidayTypeEnumerationx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public function addToHolidayType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HolidayTypeEnumerationx::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\HolidayTypeEnumerationx::getValidValues())), __LINE__);
        }
        $this->HolidayType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonitoringValidityConditionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
