<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeasurementSiteTable StructType
 * @subpackage Structs
 */
class MeasurementSiteTable extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The measurementSiteTableIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $measurementSiteTableIdentification;
    /**
     * The measurementSiteTableVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $measurementSiteTableVersion;
    /**
     * The measurementSiteRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MeasurementSiteRecord[]
     */
    public $measurementSiteRecord;
    /**
     * The measurementSiteTableExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $measurementSiteTableExtension;
    /**
     * Constructor method for MeasurementSiteTable
     * @uses MeasurementSiteTable::setId()
     * @uses MeasurementSiteTable::setMeasurementSiteTableIdentification()
     * @uses MeasurementSiteTable::setMeasurementSiteTableVersion()
     * @uses MeasurementSiteTable::setMeasurementSiteRecord()
     * @uses MeasurementSiteTable::setMeasurementSiteTableExtension()
     * @param string $id
     * @param string $measurementSiteTableIdentification
     * @param int $measurementSiteTableVersion
     * @param \StructType\MeasurementSiteRecord[] $measurementSiteRecord
     * @param \StructType\ExtensionType $measurementSiteTableExtension
     */
    public function __construct($id = null, $measurementSiteTableIdentification = null, $measurementSiteTableVersion = null, array $measurementSiteRecord = array(), \StructType\ExtensionType $measurementSiteTableExtension = null)
    {
        $this
            ->setId($id)
            ->setMeasurementSiteTableIdentification($measurementSiteTableIdentification)
            ->setMeasurementSiteTableVersion($measurementSiteTableVersion)
            ->setMeasurementSiteRecord($measurementSiteRecord)
            ->setMeasurementSiteTableExtension($measurementSiteTableExtension);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MeasurementSiteTable
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get measurementSiteTableIdentification value
     * @return string|null
     */
    public function getMeasurementSiteTableIdentification()
    {
        return $this->measurementSiteTableIdentification;
    }
    /**
     * Set measurementSiteTableIdentification value
     * @param string $measurementSiteTableIdentification
     * @return \StructType\MeasurementSiteTable
     */
    public function setMeasurementSiteTableIdentification($measurementSiteTableIdentification = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($measurementSiteTableIdentification) && strlen($measurementSiteTableIdentification) > 1024) || (is_array($measurementSiteTableIdentification) && count($measurementSiteTableIdentification) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($measurementSiteTableIdentification) ? strlen($measurementSiteTableIdentification) : count($measurementSiteTableIdentification)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($measurementSiteTableIdentification) && !is_string($measurementSiteTableIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementSiteTableIdentification)), __LINE__);
        }
        $this->measurementSiteTableIdentification = $measurementSiteTableIdentification;
        return $this;
    }
    /**
     * Get measurementSiteTableVersion value
     * @return int|null
     */
    public function getMeasurementSiteTableVersion()
    {
        return $this->measurementSiteTableVersion;
    }
    /**
     * Set measurementSiteTableVersion value
     * @param int $measurementSiteTableVersion
     * @return \StructType\MeasurementSiteTable
     */
    public function setMeasurementSiteTableVersion($measurementSiteTableVersion = null)
    {
        // validation for constraint: int
        if (!is_null($measurementSiteTableVersion) && !is_numeric($measurementSiteTableVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($measurementSiteTableVersion)), __LINE__);
        }
        $this->measurementSiteTableVersion = $measurementSiteTableVersion;
        return $this;
    }
    /**
     * Get measurementSiteRecord value
     * @return \StructType\MeasurementSiteRecord[]|null
     */
    public function getMeasurementSiteRecord()
    {
        return $this->measurementSiteRecord;
    }
    /**
     * Set measurementSiteRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasurementSiteRecord[] $measurementSiteRecord
     * @return \StructType\MeasurementSiteTable
     */
    public function setMeasurementSiteRecord(array $measurementSiteRecord = array())
    {
        foreach ($measurementSiteRecord as $measurementSiteTableMeasurementSiteRecordItem) {
            // validation for constraint: itemType
            if (!$measurementSiteTableMeasurementSiteRecordItem instanceof \StructType\MeasurementSiteRecord) {
                throw new \InvalidArgumentException(sprintf('The measurementSiteRecord property can only contain items of \StructType\MeasurementSiteRecord, "%s" given', is_object($measurementSiteTableMeasurementSiteRecordItem) ? get_class($measurementSiteTableMeasurementSiteRecordItem) : gettype($measurementSiteTableMeasurementSiteRecordItem)), __LINE__);
            }
        }
        $this->measurementSiteRecord = $measurementSiteRecord;
        return $this;
    }
    /**
     * Add item to measurementSiteRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasurementSiteRecord $item
     * @return \StructType\MeasurementSiteTable
     */
    public function addToMeasurementSiteRecord(\StructType\MeasurementSiteRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeasurementSiteRecord) {
            throw new \InvalidArgumentException(sprintf('The measurementSiteRecord property can only contain items of \StructType\MeasurementSiteRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->measurementSiteRecord[] = $item;
        return $this;
    }
    /**
     * Get measurementSiteTableExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMeasurementSiteTableExtension()
    {
        return $this->measurementSiteTableExtension;
    }
    /**
     * Set measurementSiteTableExtension value
     * @param \StructType\ExtensionType $measurementSiteTableExtension
     * @return \StructType\MeasurementSiteTable
     */
    public function setMeasurementSiteTableExtension(\StructType\ExtensionType $measurementSiteTableExtension = null)
    {
        $this->measurementSiteTableExtension = $measurementSiteTableExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeasurementSiteTable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
