<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeasurementSiteRecord StructType
 * @subpackage Structs
 */
class MeasurementSiteRecord extends AbstractStructBase
{
    /**
     * The measurementSpecificCharacteristics
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\MeasurementSpecificCharacteristics[]
     */
    public $measurementSpecificCharacteristics;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The measurementSiteRecordVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $measurementSiteRecordVersion;
    /**
     * The measurementSiteRecordVersionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $measurementSiteRecordVersionTime;
    /**
     * The computationMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $computationMethod;
    /**
     * The measurementEquipmentReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $measurementEquipmentReference;
    /**
     * The measurementEquipmentTypeUsed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $measurementEquipmentTypeUsed;
    /**
     * The measurementSiteName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $measurementSiteName;
    /**
     * The measurementSiteNumberOfLanes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $measurementSiteNumberOfLanes;
    /**
     * The measurementSiteIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $measurementSiteIdentification;
    /**
     * The measurementSide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $measurementSide;
    /**
     * The measurementSiteLocation
     * @var \StructType\Location
     */
    public $measurementSiteLocation;
    /**
     * The measurementSiteRecordExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $measurementSiteRecordExtension;
    /**
     * Constructor method for MeasurementSiteRecord
     * @uses MeasurementSiteRecord::setMeasurementSpecificCharacteristics()
     * @uses MeasurementSiteRecord::setId()
     * @uses MeasurementSiteRecord::setMeasurementSiteRecordVersion()
     * @uses MeasurementSiteRecord::setMeasurementSiteRecordVersionTime()
     * @uses MeasurementSiteRecord::setComputationMethod()
     * @uses MeasurementSiteRecord::setMeasurementEquipmentReference()
     * @uses MeasurementSiteRecord::setMeasurementEquipmentTypeUsed()
     * @uses MeasurementSiteRecord::setMeasurementSiteName()
     * @uses MeasurementSiteRecord::setMeasurementSiteNumberOfLanes()
     * @uses MeasurementSiteRecord::setMeasurementSiteIdentification()
     * @uses MeasurementSiteRecord::setMeasurementSide()
     * @uses MeasurementSiteRecord::setMeasurementSiteLocation()
     * @uses MeasurementSiteRecord::setMeasurementSiteRecordExtension()
     * @param \StructType\MeasurementSpecificCharacteristics[] $measurementSpecificCharacteristics
     * @param string $id
     * @param int $measurementSiteRecordVersion
     * @param string $measurementSiteRecordVersionTime
     * @param string $computationMethod
     * @param string $measurementEquipmentReference
     * @param \StructType\MultilingualString $measurementEquipmentTypeUsed
     * @param \StructType\MultilingualString $measurementSiteName
     * @param int $measurementSiteNumberOfLanes
     * @param string $measurementSiteIdentification
     * @param string $measurementSide
     * @param \StructType\Location $measurementSiteLocation
     * @param \StructType\ExtensionType $measurementSiteRecordExtension
     */
    public function __construct(array $measurementSpecificCharacteristics = array(), $id = null, $measurementSiteRecordVersion = null, $measurementSiteRecordVersionTime = null, $computationMethod = null, $measurementEquipmentReference = null, \StructType\MultilingualString $measurementEquipmentTypeUsed = null, \StructType\MultilingualString $measurementSiteName = null, $measurementSiteNumberOfLanes = null, $measurementSiteIdentification = null, $measurementSide = null, \StructType\Location $measurementSiteLocation = null, \StructType\ExtensionType $measurementSiteRecordExtension = null)
    {
        $this
            ->setMeasurementSpecificCharacteristics($measurementSpecificCharacteristics)
            ->setId($id)
            ->setMeasurementSiteRecordVersion($measurementSiteRecordVersion)
            ->setMeasurementSiteRecordVersionTime($measurementSiteRecordVersionTime)
            ->setComputationMethod($computationMethod)
            ->setMeasurementEquipmentReference($measurementEquipmentReference)
            ->setMeasurementEquipmentTypeUsed($measurementEquipmentTypeUsed)
            ->setMeasurementSiteName($measurementSiteName)
            ->setMeasurementSiteNumberOfLanes($measurementSiteNumberOfLanes)
            ->setMeasurementSiteIdentification($measurementSiteIdentification)
            ->setMeasurementSide($measurementSide)
            ->setMeasurementSiteLocation($measurementSiteLocation)
            ->setMeasurementSiteRecordExtension($measurementSiteRecordExtension);
    }
    /**
     * Get measurementSpecificCharacteristics value
     * @return \StructType\MeasurementSpecificCharacteristics[]
     */
    public function getMeasurementSpecificCharacteristics()
    {
        return $this->measurementSpecificCharacteristics;
    }
    /**
     * Set measurementSpecificCharacteristics value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasurementSpecificCharacteristics[] $measurementSpecificCharacteristics
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSpecificCharacteristics(array $measurementSpecificCharacteristics = array())
    {
        foreach ($measurementSpecificCharacteristics as $measurementSiteRecordMeasurementSpecificCharacteristicsItem) {
            // validation for constraint: itemType
            if (!$measurementSiteRecordMeasurementSpecificCharacteristicsItem instanceof \StructType\MeasurementSpecificCharacteristics) {
                throw new \InvalidArgumentException(sprintf('The measurementSpecificCharacteristics property can only contain items of \StructType\MeasurementSpecificCharacteristics, "%s" given', is_object($measurementSiteRecordMeasurementSpecificCharacteristicsItem) ? get_class($measurementSiteRecordMeasurementSpecificCharacteristicsItem) : gettype($measurementSiteRecordMeasurementSpecificCharacteristicsItem)), __LINE__);
            }
        }
        $this->measurementSpecificCharacteristics = $measurementSpecificCharacteristics;
        return $this;
    }
    /**
     * Add item to measurementSpecificCharacteristics value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasurementSpecificCharacteristics $item
     * @return \StructType\MeasurementSiteRecord
     */
    public function addToMeasurementSpecificCharacteristics(\StructType\MeasurementSpecificCharacteristics $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeasurementSpecificCharacteristics) {
            throw new \InvalidArgumentException(sprintf('The measurementSpecificCharacteristics property can only contain items of \StructType\MeasurementSpecificCharacteristics, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->measurementSpecificCharacteristics[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MeasurementSiteRecord
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get measurementSiteRecordVersion value
     * @return int|null
     */
    public function getMeasurementSiteRecordVersion()
    {
        return $this->measurementSiteRecordVersion;
    }
    /**
     * Set measurementSiteRecordVersion value
     * @param int $measurementSiteRecordVersion
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteRecordVersion($measurementSiteRecordVersion = null)
    {
        // validation for constraint: int
        if (!is_null($measurementSiteRecordVersion) && !is_numeric($measurementSiteRecordVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($measurementSiteRecordVersion)), __LINE__);
        }
        $this->measurementSiteRecordVersion = $measurementSiteRecordVersion;
        return $this;
    }
    /**
     * Get measurementSiteRecordVersionTime value
     * @return string|null
     */
    public function getMeasurementSiteRecordVersionTime()
    {
        return $this->measurementSiteRecordVersionTime;
    }
    /**
     * Set measurementSiteRecordVersionTime value
     * @param string $measurementSiteRecordVersionTime
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteRecordVersionTime($measurementSiteRecordVersionTime = null)
    {
        // validation for constraint: string
        if (!is_null($measurementSiteRecordVersionTime) && !is_string($measurementSiteRecordVersionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementSiteRecordVersionTime)), __LINE__);
        }
        $this->measurementSiteRecordVersionTime = $measurementSiteRecordVersionTime;
        return $this;
    }
    /**
     * Get computationMethod value
     * @return string|null
     */
    public function getComputationMethod()
    {
        return $this->computationMethod;
    }
    /**
     * Set computationMethod value
     * @uses \EnumType\ComputationMethodEnum::valueIsValid()
     * @uses \EnumType\ComputationMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $computationMethod
     * @return \StructType\MeasurementSiteRecord
     */
    public function setComputationMethod($computationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComputationMethodEnum::valueIsValid($computationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $computationMethod, implode(', ', \EnumType\ComputationMethodEnum::getValidValues())), __LINE__);
        }
        $this->computationMethod = $computationMethod;
        return $this;
    }
    /**
     * Get measurementEquipmentReference value
     * @return string|null
     */
    public function getMeasurementEquipmentReference()
    {
        return $this->measurementEquipmentReference;
    }
    /**
     * Set measurementEquipmentReference value
     * @param string $measurementEquipmentReference
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementEquipmentReference($measurementEquipmentReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($measurementEquipmentReference) && strlen($measurementEquipmentReference) > 1024) || (is_array($measurementEquipmentReference) && count($measurementEquipmentReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($measurementEquipmentReference) ? strlen($measurementEquipmentReference) : count($measurementEquipmentReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($measurementEquipmentReference) && !is_string($measurementEquipmentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementEquipmentReference)), __LINE__);
        }
        $this->measurementEquipmentReference = $measurementEquipmentReference;
        return $this;
    }
    /**
     * Get measurementEquipmentTypeUsed value
     * @return \StructType\MultilingualString|null
     */
    public function getMeasurementEquipmentTypeUsed()
    {
        return $this->measurementEquipmentTypeUsed;
    }
    /**
     * Set measurementEquipmentTypeUsed value
     * @param \StructType\MultilingualString $measurementEquipmentTypeUsed
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementEquipmentTypeUsed(\StructType\MultilingualString $measurementEquipmentTypeUsed = null)
    {
        $this->measurementEquipmentTypeUsed = $measurementEquipmentTypeUsed;
        return $this;
    }
    /**
     * Get measurementSiteName value
     * @return \StructType\MultilingualString|null
     */
    public function getMeasurementSiteName()
    {
        return $this->measurementSiteName;
    }
    /**
     * Set measurementSiteName value
     * @param \StructType\MultilingualString $measurementSiteName
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteName(\StructType\MultilingualString $measurementSiteName = null)
    {
        $this->measurementSiteName = $measurementSiteName;
        return $this;
    }
    /**
     * Get measurementSiteNumberOfLanes value
     * @return int|null
     */
    public function getMeasurementSiteNumberOfLanes()
    {
        return $this->measurementSiteNumberOfLanes;
    }
    /**
     * Set measurementSiteNumberOfLanes value
     * @param int $measurementSiteNumberOfLanes
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteNumberOfLanes($measurementSiteNumberOfLanes = null)
    {
        // validation for constraint: int
        if (!is_null($measurementSiteNumberOfLanes) && !is_numeric($measurementSiteNumberOfLanes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($measurementSiteNumberOfLanes)), __LINE__);
        }
        $this->measurementSiteNumberOfLanes = $measurementSiteNumberOfLanes;
        return $this;
    }
    /**
     * Get measurementSiteIdentification value
     * @return string|null
     */
    public function getMeasurementSiteIdentification()
    {
        return $this->measurementSiteIdentification;
    }
    /**
     * Set measurementSiteIdentification value
     * @param string $measurementSiteIdentification
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteIdentification($measurementSiteIdentification = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($measurementSiteIdentification) && strlen($measurementSiteIdentification) > 1024) || (is_array($measurementSiteIdentification) && count($measurementSiteIdentification) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($measurementSiteIdentification) ? strlen($measurementSiteIdentification) : count($measurementSiteIdentification)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($measurementSiteIdentification) && !is_string($measurementSiteIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementSiteIdentification)), __LINE__);
        }
        $this->measurementSiteIdentification = $measurementSiteIdentification;
        return $this;
    }
    /**
     * Get measurementSide value
     * @return string|null
     */
    public function getMeasurementSide()
    {
        return $this->measurementSide;
    }
    /**
     * Set measurementSide value
     * @uses \EnumType\DirectionEnum::valueIsValid()
     * @uses \EnumType\DirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $measurementSide
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSide($measurementSide = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirectionEnum::valueIsValid($measurementSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $measurementSide, implode(', ', \EnumType\DirectionEnum::getValidValues())), __LINE__);
        }
        $this->measurementSide = $measurementSide;
        return $this;
    }
    /**
     * Get measurementSiteLocation value
     * @return \StructType\Location|null
     */
    public function getMeasurementSiteLocation()
    {
        return $this->measurementSiteLocation;
    }
    /**
     * Set measurementSiteLocation value
     * @param \StructType\Location $measurementSiteLocation
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteLocation(\StructType\Location $measurementSiteLocation = null)
    {
        $this->measurementSiteLocation = $measurementSiteLocation;
        return $this;
    }
    /**
     * Get measurementSiteRecordExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMeasurementSiteRecordExtension()
    {
        return $this->measurementSiteRecordExtension;
    }
    /**
     * Set measurementSiteRecordExtension value
     * @param \StructType\ExtensionType $measurementSiteRecordExtension
     * @return \StructType\MeasurementSiteRecord
     */
    public function setMeasurementSiteRecordExtension(\StructType\ExtensionType $measurementSiteRecordExtension = null)
    {
        $this->measurementSiteRecordExtension = $measurementSiteRecordExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeasurementSiteRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
