<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatrixSignSetting StructType
 * @subpackage Structs
 */
class MatrixSignSetting extends SignSetting
{
    /**
     * The aspectDisplayed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $aspectDisplayed;
    /**
     * The matrixIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $matrixIdentifier;
    /**
     * The matrixFault
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $matrixFault;
    /**
     * The matrixSignSettingExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $matrixSignSettingExtension;
    /**
     * Constructor method for MatrixSignSetting
     * @uses MatrixSignSetting::setAspectDisplayed()
     * @uses MatrixSignSetting::setMatrixIdentifier()
     * @uses MatrixSignSetting::setMatrixFault()
     * @uses MatrixSignSetting::setMatrixSignSettingExtension()
     * @param string $aspectDisplayed
     * @param string $matrixIdentifier
     * @param string[] $matrixFault
     * @param \StructType\ExtensionType $matrixSignSettingExtension
     */
    public function __construct($aspectDisplayed = null, $matrixIdentifier = null, array $matrixFault = array(), \StructType\ExtensionType $matrixSignSettingExtension = null)
    {
        $this
            ->setAspectDisplayed($aspectDisplayed)
            ->setMatrixIdentifier($matrixIdentifier)
            ->setMatrixFault($matrixFault)
            ->setMatrixSignSettingExtension($matrixSignSettingExtension);
    }
    /**
     * Get aspectDisplayed value
     * @return string
     */
    public function getAspectDisplayed()
    {
        return $this->aspectDisplayed;
    }
    /**
     * Set aspectDisplayed value
     * @param string $aspectDisplayed
     * @return \StructType\MatrixSignSetting
     */
    public function setAspectDisplayed($aspectDisplayed = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aspectDisplayed) && strlen($aspectDisplayed) > 1024) || (is_array($aspectDisplayed) && count($aspectDisplayed) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($aspectDisplayed) ? strlen($aspectDisplayed) : count($aspectDisplayed)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aspectDisplayed) && !is_string($aspectDisplayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aspectDisplayed)), __LINE__);
        }
        $this->aspectDisplayed = $aspectDisplayed;
        return $this;
    }
    /**
     * Get matrixIdentifier value
     * @return string
     */
    public function getMatrixIdentifier()
    {
        return $this->matrixIdentifier;
    }
    /**
     * Set matrixIdentifier value
     * @param string $matrixIdentifier
     * @return \StructType\MatrixSignSetting
     */
    public function setMatrixIdentifier($matrixIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($matrixIdentifier) && strlen($matrixIdentifier) > 1024) || (is_array($matrixIdentifier) && count($matrixIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($matrixIdentifier) ? strlen($matrixIdentifier) : count($matrixIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($matrixIdentifier) && !is_string($matrixIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($matrixIdentifier)), __LINE__);
        }
        $this->matrixIdentifier = $matrixIdentifier;
        return $this;
    }
    /**
     * Get matrixFault value
     * @return string[]|null
     */
    public function getMatrixFault()
    {
        return $this->matrixFault;
    }
    /**
     * Set matrixFault value
     * @uses \EnumType\MatrixFaultEnum::valueIsValid()
     * @uses \EnumType\MatrixFaultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $matrixFault
     * @return \StructType\MatrixSignSetting
     */
    public function setMatrixFault(array $matrixFault = array())
    {
        $invalidValues = array();
        foreach ($matrixFault as $matrixSignSettingMatrixFaultItem) {
            if (!\EnumType\MatrixFaultEnum::valueIsValid($matrixSignSettingMatrixFaultItem)) {
                $invalidValues[] = var_export($matrixSignSettingMatrixFaultItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\MatrixFaultEnum::getValidValues())), __LINE__);
        }
        $this->matrixFault = $matrixFault;
        return $this;
    }
    /**
     * Add item to matrixFault value
     * @uses \EnumType\MatrixFaultEnum::valueIsValid()
     * @uses \EnumType\MatrixFaultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MatrixSignSetting
     */
    public function addToMatrixFault($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatrixFaultEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\MatrixFaultEnum::getValidValues())), __LINE__);
        }
        $this->matrixFault[] = $item;
        return $this;
    }
    /**
     * Get matrixSignSettingExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMatrixSignSettingExtension()
    {
        return $this->matrixSignSettingExtension;
    }
    /**
     * Set matrixSignSettingExtension value
     * @param \StructType\ExtensionType $matrixSignSettingExtension
     * @return \StructType\MatrixSignSetting
     */
    public function setMatrixSignSettingExtension(\StructType\ExtensionType $matrixSignSettingExtension = null)
    {
        $this->matrixSignSettingExtension = $matrixSignSettingExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MatrixSignSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
