<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaintenanceWorks StructType
 * @subpackage Structs
 */
class MaintenanceWorks extends Roadworks
{
    /**
     * The roadMaintenanceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $roadMaintenanceType;
    /**
     * The maintenanceWorksExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $maintenanceWorksExtension;
    /**
     * Constructor method for MaintenanceWorks
     * @uses MaintenanceWorks::setRoadMaintenanceType()
     * @uses MaintenanceWorks::setMaintenanceWorksExtension()
     * @param string[] $roadMaintenanceType
     * @param \StructType\ExtensionType $maintenanceWorksExtension
     */
    public function __construct(array $roadMaintenanceType = array(), \StructType\ExtensionType $maintenanceWorksExtension = null)
    {
        $this
            ->setRoadMaintenanceType($roadMaintenanceType)
            ->setMaintenanceWorksExtension($maintenanceWorksExtension);
    }
    /**
     * Get roadMaintenanceType value
     * @return string[]
     */
    public function getRoadMaintenanceType()
    {
        return $this->roadMaintenanceType;
    }
    /**
     * Set roadMaintenanceType value
     * @uses \EnumType\RoadMaintenanceTypeEnum::valueIsValid()
     * @uses \EnumType\RoadMaintenanceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $roadMaintenanceType
     * @return \StructType\MaintenanceWorks
     */
    public function setRoadMaintenanceType(array $roadMaintenanceType = array())
    {
        $invalidValues = array();
        foreach ($roadMaintenanceType as $maintenanceWorksRoadMaintenanceTypeItem) {
            if (!\EnumType\RoadMaintenanceTypeEnum::valueIsValid($maintenanceWorksRoadMaintenanceTypeItem)) {
                $invalidValues[] = var_export($maintenanceWorksRoadMaintenanceTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RoadMaintenanceTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadMaintenanceType = $roadMaintenanceType;
        return $this;
    }
    /**
     * Add item to roadMaintenanceType value
     * @uses \EnumType\RoadMaintenanceTypeEnum::valueIsValid()
     * @uses \EnumType\RoadMaintenanceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MaintenanceWorks
     */
    public function addToRoadMaintenanceType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadMaintenanceTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RoadMaintenanceTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadMaintenanceType[] = $item;
        return $this;
    }
    /**
     * Get maintenanceWorksExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMaintenanceWorksExtension()
    {
        return $this->maintenanceWorksExtension;
    }
    /**
     * Set maintenanceWorksExtension value
     * @param \StructType\ExtensionType $maintenanceWorksExtension
     * @return \StructType\MaintenanceWorks
     */
    public function setMaintenanceWorksExtension(\StructType\ExtensionType $maintenanceWorksExtension = null)
    {
        $this->maintenanceWorksExtension = $maintenanceWorksExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaintenanceWorks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
