<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for gepspatial Position of a point. May be expressed in concrete WGS 84 Coordinates or any gml compatible point coordinates format.
 * @subpackage Structs
 */
class LocationStructure extends AbstractStructBase
{
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - documentation: Longitude from Greenwich Meridian. -180 (West) to +180 (East). Decimal degrees. eg 2.356 | Longitude from Greenwich.
     * - maxInclusive: 180
     * - minInclusive: -180
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - documentation: Latitude from equator. -90 (South) to +90 (North). Decimal degrees. eg 56.356 | Latitude from equator.
     * - maxInclusive: 90
     * - minInclusive: -90
     * @var float
     */
    public $Latitude;
    /**
     * The Coordinates
     * Meta informations extracted from the WSDL
     * - documentation: Coordinates of points in a GML compatibe format, as indicated by srsName attribute.
     * @var \StructType\CoordinatesStructure
     */
    public $Coordinates;
    /**
     * The Precision
     * Meta informations extracted from the WSDL
     * - documentation: Precision for point measurement. In meters. | Distance (metres) as defined by http://www.ordnancesurvey.co.uk/xml/resource/units.xml#metres. ALternative units may be specifed by context.
     * - minOccurs: 0
     * @var int
     */
    public $Precision;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of POINT.
     * @var string
     */
    public $id;
    /**
     * The srsName
     * Meta informations extracted from the WSDL
     * - documentation: identifier of data reference system for geocodes if point is specified as gml compatible Coordinates. A gml value. If not specified taken from system configuration. | Type for coordinate reference system.
     * @var string
     */
    public $srsName;
    /**
     * Constructor method for LocationStructure
     * @uses LocationStructure::setLongitude()
     * @uses LocationStructure::setLatitude()
     * @uses LocationStructure::setCoordinates()
     * @uses LocationStructure::setPrecision()
     * @uses LocationStructure::setId()
     * @uses LocationStructure::setSrsName()
     * @param float $longitude
     * @param float $latitude
     * @param \StructType\CoordinatesStructure $coordinates
     * @param int $precision
     * @param string $id
     * @param string $srsName
     */
    public function __construct($longitude = null, $latitude = null, \StructType\CoordinatesStructure $coordinates = null, $precision = null, $id = null, $srsName = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setCoordinates($coordinates)
            ->setPrecision($precision)
            ->setId($id)
            ->setSrsName($srsName);
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\LocationStructure
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: maxInclusive
        if ($longitude > 180) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 180, "%s" given', $longitude), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($longitude < -180) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -180, "%s" given', $longitude), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\LocationStructure
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: maxInclusive
        if ($latitude > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 90, "%s" given', $latitude), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($latitude < -90) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -90, "%s" given', $latitude), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Coordinates value
     * @return \StructType\CoordinatesStructure|null
     */
    public function getCoordinates()
    {
        return $this->Coordinates;
    }
    /**
     * Set Coordinates value
     * @param \StructType\CoordinatesStructure $coordinates
     * @return \StructType\LocationStructure
     */
    public function setCoordinates(\StructType\CoordinatesStructure $coordinates = null)
    {
        $this->Coordinates = $coordinates;
        return $this;
    }
    /**
     * Get Precision value
     * @return int|null
     */
    public function getPrecision()
    {
        return $this->Precision;
    }
    /**
     * Set Precision value
     * @param int $precision
     * @return \StructType\LocationStructure
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !is_numeric($precision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($precision)), __LINE__);
        }
        $this->Precision = $precision;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\LocationStructure
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get srsName value
     * @return string|null
     */
    public function getSrsName()
    {
        return $this->srsName;
    }
    /**
     * Set srsName value
     * @param string $srsName
     * @return \StructType\LocationStructure
     */
    public function setSrsName($srsName = null)
    {
        // validation for constraint: string
        if (!is_null($srsName) && !is_string($srsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srsName)), __LINE__);
        }
        $this->srsName = $srsName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
