<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationCharacteristicsOverride StructType
 * @subpackage Structs
 */
class LocationCharacteristicsOverride extends AbstractStructBase
{
    /**
     * The measurementLanesOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $measurementLanesOverride;
    /**
     * The reversedFlow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $reversedFlow;
    /**
     * The locationCharacteristicsOverrideExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $locationCharacteristicsOverrideExtension;
    /**
     * Constructor method for LocationCharacteristicsOverride
     * @uses LocationCharacteristicsOverride::setMeasurementLanesOverride()
     * @uses LocationCharacteristicsOverride::setReversedFlow()
     * @uses LocationCharacteristicsOverride::setLocationCharacteristicsOverrideExtension()
     * @param string $measurementLanesOverride
     * @param bool $reversedFlow
     * @param \StructType\ExtensionType $locationCharacteristicsOverrideExtension
     */
    public function __construct($measurementLanesOverride = null, $reversedFlow = null, \StructType\ExtensionType $locationCharacteristicsOverrideExtension = null)
    {
        $this
            ->setMeasurementLanesOverride($measurementLanesOverride)
            ->setReversedFlow($reversedFlow)
            ->setLocationCharacteristicsOverrideExtension($locationCharacteristicsOverrideExtension);
    }
    /**
     * Get measurementLanesOverride value
     * @return string|null
     */
    public function getMeasurementLanesOverride()
    {
        return $this->measurementLanesOverride;
    }
    /**
     * Set measurementLanesOverride value
     * @uses \EnumType\LaneEnum::valueIsValid()
     * @uses \EnumType\LaneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $measurementLanesOverride
     * @return \StructType\LocationCharacteristicsOverride
     */
    public function setMeasurementLanesOverride($measurementLanesOverride = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LaneEnum::valueIsValid($measurementLanesOverride)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $measurementLanesOverride, implode(', ', \EnumType\LaneEnum::getValidValues())), __LINE__);
        }
        $this->measurementLanesOverride = $measurementLanesOverride;
        return $this;
    }
    /**
     * Get reversedFlow value
     * @return bool|null
     */
    public function getReversedFlow()
    {
        return $this->reversedFlow;
    }
    /**
     * Set reversedFlow value
     * @param bool $reversedFlow
     * @return \StructType\LocationCharacteristicsOverride
     */
    public function setReversedFlow($reversedFlow = null)
    {
        // validation for constraint: boolean
        if (!is_null($reversedFlow) && !is_bool($reversedFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reversedFlow)), __LINE__);
        }
        $this->reversedFlow = $reversedFlow;
        return $this;
    }
    /**
     * Get locationCharacteristicsOverrideExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getLocationCharacteristicsOverrideExtension()
    {
        return $this->locationCharacteristicsOverrideExtension;
    }
    /**
     * Set locationCharacteristicsOverrideExtension value
     * @param \StructType\ExtensionType $locationCharacteristicsOverrideExtension
     * @return \StructType\LocationCharacteristicsOverride
     */
    public function setLocationCharacteristicsOverrideExtension(\StructType\ExtensionType $locationCharacteristicsOverrideExtension = null)
    {
        $this->locationCharacteristicsOverrideExtension = $locationCharacteristicsOverrideExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationCharacteristicsOverride
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
