<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationByReference StructType
 * @subpackage Structs
 */
class LocationByReference extends Location
{
    /**
     * The predefinedLocationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $predefinedLocationReference;
    /**
     * The locationByReferenceExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $locationByReferenceExtension;
    /**
     * Constructor method for LocationByReference
     * @uses LocationByReference::setPredefinedLocationReference()
     * @uses LocationByReference::setLocationByReferenceExtension()
     * @param string $predefinedLocationReference
     * @param \StructType\ExtensionType $locationByReferenceExtension
     */
    public function __construct($predefinedLocationReference = null, \StructType\ExtensionType $locationByReferenceExtension = null)
    {
        $this
            ->setPredefinedLocationReference($predefinedLocationReference)
            ->setLocationByReferenceExtension($locationByReferenceExtension);
    }
    /**
     * Get predefinedLocationReference value
     * @return string
     */
    public function getPredefinedLocationReference()
    {
        return $this->predefinedLocationReference;
    }
    /**
     * Set predefinedLocationReference value
     * @param string $predefinedLocationReference
     * @return \StructType\LocationByReference
     */
    public function setPredefinedLocationReference($predefinedLocationReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($predefinedLocationReference) && strlen($predefinedLocationReference) > 1024) || (is_array($predefinedLocationReference) && count($predefinedLocationReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($predefinedLocationReference) ? strlen($predefinedLocationReference) : count($predefinedLocationReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($predefinedLocationReference) && !is_string($predefinedLocationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($predefinedLocationReference)), __LINE__);
        }
        $this->predefinedLocationReference = $predefinedLocationReference;
        return $this;
    }
    /**
     * Get locationByReferenceExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getLocationByReferenceExtension()
    {
        return $this->locationByReferenceExtension;
    }
    /**
     * Set locationByReferenceExtension value
     * @param \StructType\ExtensionType $locationByReferenceExtension
     * @return \StructType\LocationByReference
     */
    public function setLocationByReferenceExtension(\StructType\ExtensionType $locationByReferenceExtension = null)
    {
        $this->locationByReferenceExtension = $locationByReferenceExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationByReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
