<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinesDiscoveryRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Requests for LINE data for use in service requests.
 * @subpackage Structs
 */
class LinesDiscoveryRequestStructure extends AbstractDiscoveryRequestStructure
{
    /**
     * The BoundingBox
     * @var \StructType\BoundingBoxStructure
     */
    public $BoundingBox;
    /**
     * The Circle
     * @var \StructType\LocationStructure
     */
    public $Circle;
    /**
     * The PlaceRef
     * @var string
     */
    public $PlaceRef;
    /**
     * The LineDirectionRef
     * @var \StructType\LineDirectionStructure
     */
    public $LineDirectionRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The LinesDetailLevel
     * @var string
     */
    public $LinesDetailLevel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for LinesDiscoveryRequestStructure
     * @uses LinesDiscoveryRequestStructure::setBoundingBox()
     * @uses LinesDiscoveryRequestStructure::setCircle()
     * @uses LinesDiscoveryRequestStructure::setPlaceRef()
     * @uses LinesDiscoveryRequestStructure::setLineDirectionRef()
     * @uses LinesDiscoveryRequestStructure::setOperatorRef()
     * @uses LinesDiscoveryRequestStructure::setLanguage()
     * @uses LinesDiscoveryRequestStructure::setLinesDetailLevel()
     * @uses LinesDiscoveryRequestStructure::setExtensions()
     * @uses LinesDiscoveryRequestStructure::setVersion()
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @param \StructType\LocationStructure $circle
     * @param string $placeRef
     * @param \StructType\LineDirectionStructure $lineDirectionRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param string $language
     * @param string $linesDetailLevel
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\BoundingBoxStructure $boundingBox = null, \StructType\LocationStructure $circle = null, $placeRef = null, \StructType\LineDirectionStructure $lineDirectionRef = null, \StructType\OperatorRefStructure $operatorRef = null, $language = null, $linesDetailLevel = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setBoundingBox($boundingBox)
            ->setCircle($circle)
            ->setPlaceRef($placeRef)
            ->setLineDirectionRef($lineDirectionRef)
            ->setOperatorRef($operatorRef)
            ->setLanguage($language)
            ->setLinesDetailLevel($linesDetailLevel)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get BoundingBox value
     * @return \StructType\BoundingBoxStructure|null
     */
    public function getBoundingBox()
    {
        return $this->BoundingBox;
    }
    /**
     * Set BoundingBox value
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setBoundingBox(\StructType\BoundingBoxStructure $boundingBox = null)
    {
        $this->BoundingBox = $boundingBox;
        return $this;
    }
    /**
     * Get Circle value
     * @return \StructType\LocationStructure|null
     */
    public function getCircle()
    {
        return $this->Circle;
    }
    /**
     * Set Circle value
     * @param \StructType\LocationStructure $circle
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setCircle(\StructType\LocationStructure $circle = null)
    {
        $this->Circle = $circle;
        return $this;
    }
    /**
     * Get PlaceRef value
     * @return string|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param string $placeRef
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setPlaceRef($placeRef = null)
    {
        // validation for constraint: string
        if (!is_null($placeRef) && !is_string($placeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeRef)), __LINE__);
        }
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get LineDirectionRef value
     * @return \StructType\LineDirectionStructure|null
     */
    public function getLineDirectionRef()
    {
        return $this->LineDirectionRef;
    }
    /**
     * Set LineDirectionRef value
     * @param \StructType\LineDirectionStructure $lineDirectionRef
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setLineDirectionRef(\StructType\LineDirectionStructure $lineDirectionRef = null)
    {
        $this->LineDirectionRef = $lineDirectionRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get LinesDetailLevel value
     * @return string|null
     */
    public function getLinesDetailLevel()
    {
        return $this->LinesDetailLevel;
    }
    /**
     * Set LinesDetailLevel value
     * @uses \EnumType\LinesDetailEnumeration::valueIsValid()
     * @uses \EnumType\LinesDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $linesDetailLevel
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setLinesDetailLevel($linesDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LinesDetailEnumeration::valueIsValid($linesDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $linesDetailLevel, implode(', ', \EnumType\LinesDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->LinesDetailLevel = $linesDetailLevel;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinesDiscoveryRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
