<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinePermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: The LINEs that the participant may access.
 * @subpackage Structs
 */
class LinePermissions extends AbstractStructBase
{
    /**
     * The AllowAll
     * Meta informations extracted from the WSDL
     * - ref: AllowAll
     * @var bool
     */
    public $AllowAll;
    /**
     * The LinePermission
     * Meta informations extracted from the WSDL
     * - documentation: Participant's permission for this LINE.
     * - maxOccurs: unbounded
     * @var \StructType\LinePermissionStructure[]
     */
    public $LinePermission;
    /**
     * Constructor method for LinePermissions
     * @uses LinePermissions::setAllowAll()
     * @uses LinePermissions::setLinePermission()
     * @param bool $allowAll
     * @param \StructType\LinePermissionStructure[] $linePermission
     */
    public function __construct($allowAll = null, array $linePermission = array())
    {
        $this
            ->setAllowAll($allowAll)
            ->setLinePermission($linePermission);
    }
    /**
     * Get AllowAll value
     * @return bool|null
     */
    public function getAllowAll()
    {
        return $this->AllowAll;
    }
    /**
     * Set AllowAll value
     * @param bool $allowAll
     * @return \StructType\LinePermissions
     */
    public function setAllowAll($allowAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAll) && !is_bool($allowAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowAll)), __LINE__);
        }
        $this->AllowAll = $allowAll;
        return $this;
    }
    /**
     * Get LinePermission value
     * @return \StructType\LinePermissionStructure[]|null
     */
    public function getLinePermission()
    {
        return $this->LinePermission;
    }
    /**
     * Set LinePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\LinePermissionStructure[] $linePermission
     * @return \StructType\LinePermissions
     */
    public function setLinePermission(array $linePermission = array())
    {
        foreach ($linePermission as $linePermissionsLinePermissionItem) {
            // validation for constraint: itemType
            if (!$linePermissionsLinePermissionItem instanceof \StructType\LinePermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The LinePermission property can only contain items of \StructType\LinePermissionStructure, "%s" given', is_object($linePermissionsLinePermissionItem) ? get_class($linePermissionsLinePermissionItem) : gettype($linePermissionsLinePermissionItem)), __LINE__);
            }
        }
        $this->LinePermission = $linePermission;
        return $this;
    }
    /**
     * Add item to LinePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\LinePermissionStructure $item
     * @return \StructType\LinePermissions
     */
    public function addToLinePermission(\StructType\LinePermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinePermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The LinePermission property can only contain items of \StructType\LinePermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinePermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinePermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
