<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Limitations StructType
 * Meta informations extracted from the WSDL
 * - documentation: Limitation of facility. | The Limitations that apply to component.
 * - minOccurs: 0
 * @subpackage Structs
 */
class Limitations extends AbstractStructBase
{
    /**
     * The AccessibilityLimitation
     * Meta informations extracted from the WSDL
     * - documentation: The accessibility limitations of a component.
     * - maxOccurs: unbounded
     * @var \StructType\AccessibilityLimitationStructure[]
     */
    public $AccessibilityLimitation;
    /**
     * The WheelchairAccess
     * @var \StructType\AccessibilityStructure
     */
    public $WheelchairAccess;
    /**
     * The StepFreeAccess
     * @var \StructType\AccessibilityStructure
     */
    public $StepFreeAccess;
    /**
     * The EscalatorFreeAccess
     * @var \StructType\AccessibilityStructure
     */
    public $EscalatorFreeAccess;
    /**
     * The LiftFreeAccess
     * @var \StructType\AccessibilityStructure
     */
    public $LiftFreeAccess;
    /**
     * The AudibleSignalsAvailable
     * @var \StructType\AccessibilityStructure
     */
    public $AudibleSignalsAvailable;
    /**
     * The VisualSignsAvailable
     * @var \StructType\AccessibilityStructure
     */
    public $VisualSignsAvailable;
    /**
     * Constructor method for Limitations
     * @uses Limitations::setAccessibilityLimitation()
     * @uses Limitations::setWheelchairAccess()
     * @uses Limitations::setStepFreeAccess()
     * @uses Limitations::setEscalatorFreeAccess()
     * @uses Limitations::setLiftFreeAccess()
     * @uses Limitations::setAudibleSignalsAvailable()
     * @uses Limitations::setVisualSignsAvailable()
     * @param \StructType\AccessibilityLimitationStructure[] $accessibilityLimitation
     * @param \StructType\AccessibilityStructure $wheelchairAccess
     * @param \StructType\AccessibilityStructure $stepFreeAccess
     * @param \StructType\AccessibilityStructure $escalatorFreeAccess
     * @param \StructType\AccessibilityStructure $liftFreeAccess
     * @param \StructType\AccessibilityStructure $audibleSignalsAvailable
     * @param \StructType\AccessibilityStructure $visualSignsAvailable
     */
    public function __construct(array $accessibilityLimitation = array(), \StructType\AccessibilityStructure $wheelchairAccess = null, \StructType\AccessibilityStructure $stepFreeAccess = null, \StructType\AccessibilityStructure $escalatorFreeAccess = null, \StructType\AccessibilityStructure $liftFreeAccess = null, \StructType\AccessibilityStructure $audibleSignalsAvailable = null, \StructType\AccessibilityStructure $visualSignsAvailable = null)
    {
        $this
            ->setAccessibilityLimitation($accessibilityLimitation)
            ->setWheelchairAccess($wheelchairAccess)
            ->setStepFreeAccess($stepFreeAccess)
            ->setEscalatorFreeAccess($escalatorFreeAccess)
            ->setLiftFreeAccess($liftFreeAccess)
            ->setAudibleSignalsAvailable($audibleSignalsAvailable)
            ->setVisualSignsAvailable($visualSignsAvailable);
    }
    /**
     * Get AccessibilityLimitation value
     * @return \StructType\AccessibilityLimitationStructure[]|null
     */
    public function getAccessibilityLimitation()
    {
        return $this->AccessibilityLimitation;
    }
    /**
     * Set AccessibilityLimitation value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessibilityLimitationStructure[] $accessibilityLimitation
     * @return \StructType\Limitations
     */
    public function setAccessibilityLimitation(array $accessibilityLimitation = array())
    {
        foreach ($accessibilityLimitation as $limitationsAccessibilityLimitationItem) {
            // validation for constraint: itemType
            if (!$limitationsAccessibilityLimitationItem instanceof \StructType\AccessibilityLimitationStructure) {
                throw new \InvalidArgumentException(sprintf('The AccessibilityLimitation property can only contain items of \StructType\AccessibilityLimitationStructure, "%s" given', is_object($limitationsAccessibilityLimitationItem) ? get_class($limitationsAccessibilityLimitationItem) : gettype($limitationsAccessibilityLimitationItem)), __LINE__);
            }
        }
        $this->AccessibilityLimitation = $accessibilityLimitation;
        return $this;
    }
    /**
     * Add item to AccessibilityLimitation value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessibilityLimitationStructure $item
     * @return \StructType\Limitations
     */
    public function addToAccessibilityLimitation(\StructType\AccessibilityLimitationStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessibilityLimitationStructure) {
            throw new \InvalidArgumentException(sprintf('The AccessibilityLimitation property can only contain items of \StructType\AccessibilityLimitationStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccessibilityLimitation[] = $item;
        return $this;
    }
    /**
     * Get WheelchairAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getWheelchairAccess()
    {
        return $this->WheelchairAccess;
    }
    /**
     * Set WheelchairAccess value
     * @param \StructType\AccessibilityStructure $wheelchairAccess
     * @return \StructType\Limitations
     */
    public function setWheelchairAccess(\StructType\AccessibilityStructure $wheelchairAccess = null)
    {
        $this->WheelchairAccess = $wheelchairAccess;
        return $this;
    }
    /**
     * Get StepFreeAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getStepFreeAccess()
    {
        return $this->StepFreeAccess;
    }
    /**
     * Set StepFreeAccess value
     * @param \StructType\AccessibilityStructure $stepFreeAccess
     * @return \StructType\Limitations
     */
    public function setStepFreeAccess(\StructType\AccessibilityStructure $stepFreeAccess = null)
    {
        $this->StepFreeAccess = $stepFreeAccess;
        return $this;
    }
    /**
     * Get EscalatorFreeAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getEscalatorFreeAccess()
    {
        return $this->EscalatorFreeAccess;
    }
    /**
     * Set EscalatorFreeAccess value
     * @param \StructType\AccessibilityStructure $escalatorFreeAccess
     * @return \StructType\Limitations
     */
    public function setEscalatorFreeAccess(\StructType\AccessibilityStructure $escalatorFreeAccess = null)
    {
        $this->EscalatorFreeAccess = $escalatorFreeAccess;
        return $this;
    }
    /**
     * Get LiftFreeAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getLiftFreeAccess()
    {
        return $this->LiftFreeAccess;
    }
    /**
     * Set LiftFreeAccess value
     * @param \StructType\AccessibilityStructure $liftFreeAccess
     * @return \StructType\Limitations
     */
    public function setLiftFreeAccess(\StructType\AccessibilityStructure $liftFreeAccess = null)
    {
        $this->LiftFreeAccess = $liftFreeAccess;
        return $this;
    }
    /**
     * Get AudibleSignalsAvailable value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getAudibleSignalsAvailable()
    {
        return $this->AudibleSignalsAvailable;
    }
    /**
     * Set AudibleSignalsAvailable value
     * @param \StructType\AccessibilityStructure $audibleSignalsAvailable
     * @return \StructType\Limitations
     */
    public function setAudibleSignalsAvailable(\StructType\AccessibilityStructure $audibleSignalsAvailable = null)
    {
        $this->AudibleSignalsAvailable = $audibleSignalsAvailable;
        return $this;
    }
    /**
     * Get VisualSignsAvailable value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getVisualSignsAvailable()
    {
        return $this->VisualSignsAvailable;
    }
    /**
     * Set VisualSignsAvailable value
     * @param \StructType\AccessibilityStructure $visualSignsAvailable
     * @return \StructType\Limitations
     */
    public function setVisualSignsAvailable(\StructType\AccessibilityStructure $visualSignsAvailable = null)
    {
        $this->VisualSignsAvailable = $visualSignsAvailable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Limitations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
