<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JourneyPattern StructType
 * Meta informations extracted from the WSDL
 * - documentation: JourneyPattern. (+SIRI 2.0)
 * @subpackage Structs
 */
class JourneyPattern extends AbstractStructBase
{
    /**
     * The JourneyPatternRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: JourneyPatternRef
     * @var \StructType\JourneyPatternRefStructure
     */
    public $JourneyPatternRef;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name Of Journety Pattern (SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Name;
    /**
     * The StopsInPattern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StopsInPattern
     */
    public $StopsInPattern;
    /**
     * Constructor method for JourneyPattern
     * @uses JourneyPattern::setJourneyPatternRef()
     * @uses JourneyPattern::setName()
     * @uses JourneyPattern::setStopsInPattern()
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @param \StructType\StopsInPattern $stopsInPattern
     */
    public function __construct(\StructType\JourneyPatternRefStructure $journeyPatternRef = null, array $name = array(), \StructType\StopsInPattern $stopsInPattern = null)
    {
        $this
            ->setJourneyPatternRef($journeyPatternRef)
            ->setName($name)
            ->setStopsInPattern($stopsInPattern);
    }
    /**
     * Get JourneyPatternRef value
     * @return \StructType\JourneyPatternRefStructure|null
     */
    public function getJourneyPatternRef()
    {
        return $this->JourneyPatternRef;
    }
    /**
     * Set JourneyPatternRef value
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @return \StructType\JourneyPattern
     */
    public function setJourneyPatternRef(\StructType\JourneyPatternRefStructure $journeyPatternRef = null)
    {
        $this->JourneyPatternRef = $journeyPatternRef;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @return \StructType\JourneyPattern
     */
    public function setName(array $name = array())
    {
        foreach ($name as $journeyPatternNameItem) {
            // validation for constraint: itemType
            if (!$journeyPatternNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($journeyPatternNameItem) ? get_class($journeyPatternNameItem) : gettype($journeyPatternNameItem)), __LINE__);
            }
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Add item to Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\JourneyPattern
     */
    public function addToName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Name[] = $item;
        return $this;
    }
    /**
     * Get StopsInPattern value
     * @return \StructType\StopsInPattern|null
     */
    public function getStopsInPattern()
    {
        return $this->StopsInPattern;
    }
    /**
     * Set StopsInPattern value
     * @param \StructType\StopsInPattern $stopsInPattern
     * @return \StructType\JourneyPattern
     */
    public function setStopsInPattern(\StructType\StopsInPattern $stopsInPattern = null)
    {
        $this->StopsInPattern = $stopsInPattern;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JourneyPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
