<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidDataReferencesErrorStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for InvalidDataReferencesError:. +SIRI v2.0.
 * @subpackage Structs
 */
class InvalidDataReferencesErrorStructure extends ErrorCodeStructure
{
    /**
     * The InvalidRef
     * Meta informations extracted from the WSDL
     * - documentation: Invalid reference values encoountered.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvalidRef;
    /**
     * Constructor method for InvalidDataReferencesErrorStructure
     * @uses InvalidDataReferencesErrorStructure::setInvalidRef()
     * @param string[] $invalidRef
     */
    public function __construct(array $invalidRef = array())
    {
        $this
            ->setInvalidRef($invalidRef);
    }
    /**
     * Get InvalidRef value
     * @return string[]|null
     */
    public function getInvalidRef()
    {
        return $this->InvalidRef;
    }
    /**
     * Set InvalidRef value
     * @throws \InvalidArgumentException
     * @param string[] $invalidRef
     * @return \StructType\InvalidDataReferencesErrorStructure
     */
    public function setInvalidRef(array $invalidRef = array())
    {
        foreach ($invalidRef as $invalidDataReferencesErrorStructureInvalidRefItem) {
            // validation for constraint: itemType
            if (!is_string($invalidDataReferencesErrorStructureInvalidRefItem)) {
                throw new \InvalidArgumentException(sprintf('The InvalidRef property can only contain items of NMTOKEN, "%s" given', is_object($invalidDataReferencesErrorStructureInvalidRefItem) ? get_class($invalidDataReferencesErrorStructureInvalidRefItem) : gettype($invalidDataReferencesErrorStructureInvalidRefItem)), __LINE__);
            }
        }
        $this->InvalidRef = $invalidRef;
        return $this;
    }
    /**
     * Add item to InvalidRef value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\InvalidDataReferencesErrorStructure
     */
    public function addToInvalidRef($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The InvalidRef property can only contain items of NMTOKEN, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvalidRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvalidDataReferencesErrorStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
