<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoLinks StructType
 * Meta informations extracted from the WSDL
 * - documentation: Hyperlinks to other resources associated with SITUATION. | Collection of URL's associated with object.
 * - minOccurs: 0
 * - type: InfoLinksStructure
 * @subpackage Structs
 */
class InfoLinks extends AbstractStructBase
{
    /**
     * The InfoLink
     * Meta informations extracted from the WSDL
     * - documentation: Hyperlink description.
     * - maxOccurs: unbounded
     * @var \StructType\InfoLinkStructure[]
     */
    public $InfoLink;
    /**
     * Constructor method for InfoLinks
     * @uses InfoLinks::setInfoLink()
     * @param \StructType\InfoLinkStructure[] $infoLink
     */
    public function __construct(array $infoLink = array())
    {
        $this
            ->setInfoLink($infoLink);
    }
    /**
     * Get InfoLink value
     * @return \StructType\InfoLinkStructure[]|null
     */
    public function getInfoLink()
    {
        return $this->InfoLink;
    }
    /**
     * Set InfoLink value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoLinkStructure[] $infoLink
     * @return \StructType\InfoLinks
     */
    public function setInfoLink(array $infoLink = array())
    {
        foreach ($infoLink as $infoLinksInfoLinkItem) {
            // validation for constraint: itemType
            if (!$infoLinksInfoLinkItem instanceof \StructType\InfoLinkStructure) {
                throw new \InvalidArgumentException(sprintf('The InfoLink property can only contain items of \StructType\InfoLinkStructure, "%s" given', is_object($infoLinksInfoLinkItem) ? get_class($infoLinksInfoLinkItem) : gettype($infoLinksInfoLinkItem)), __LINE__);
            }
        }
        $this->InfoLink = $infoLink;
        return $this;
    }
    /**
     * Add item to InfoLink value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoLinkStructure $item
     * @return \StructType\InfoLinks
     */
    public function addToInfoLink(\StructType\InfoLinkStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoLinkStructure) {
            throw new \InvalidArgumentException(sprintf('The InfoLink property can only contain items of \StructType\InfoLinkStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfoLink[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoLinks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
