<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoChannelDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Response with Info channels categories available to make requests.
 * @subpackage Structs
 */
class InfoChannelDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The InfoChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: InfoChannel
     * @var \StructType\InfoChannelStructure[]
     */
    public $InfoChannel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for InfoChannelDeliveryStructure
     * @uses InfoChannelDeliveryStructure::setInfoChannel()
     * @uses InfoChannelDeliveryStructure::setExtensions()
     * @uses InfoChannelDeliveryStructure::setVersion()
     * @param \StructType\InfoChannelStructure[] $infoChannel
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(array $infoChannel = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setInfoChannel($infoChannel)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get InfoChannel value
     * @return \StructType\InfoChannelStructure[]|null
     */
    public function getInfoChannel()
    {
        return $this->InfoChannel;
    }
    /**
     * Set InfoChannel value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoChannelStructure[] $infoChannel
     * @return \StructType\InfoChannelDeliveryStructure
     */
    public function setInfoChannel(array $infoChannel = array())
    {
        foreach ($infoChannel as $infoChannelDeliveryStructureInfoChannelItem) {
            // validation for constraint: itemType
            if (!$infoChannelDeliveryStructureInfoChannelItem instanceof \StructType\InfoChannelStructure) {
                throw new \InvalidArgumentException(sprintf('The InfoChannel property can only contain items of \StructType\InfoChannelStructure, "%s" given', is_object($infoChannelDeliveryStructureInfoChannelItem) ? get_class($infoChannelDeliveryStructureInfoChannelItem) : gettype($infoChannelDeliveryStructureInfoChannelItem)), __LINE__);
            }
        }
        $this->InfoChannel = $infoChannel;
        return $this;
    }
    /**
     * Add item to InfoChannel value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoChannelStructure $item
     * @return \StructType\InfoChannelDeliveryStructure
     */
    public function addToInfoChannel(\StructType\InfoChannelStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoChannelStructure) {
            throw new \InvalidArgumentException(sprintf('The InfoChannel property can only contain items of \StructType\InfoChannelStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfoChannel[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\InfoChannelDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\InfoChannelDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoChannelDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
