<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Impact StructType
 * @subpackage Structs
 */
class Impact extends AbstractStructBase
{
    /**
     * The capacityRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $capacityRemaining;
    /**
     * The numberOfLanesRestricted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfLanesRestricted;
    /**
     * The numberOfOperationalLanes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfOperationalLanes;
    /**
     * The originalNumberOfLanes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $originalNumberOfLanes;
    /**
     * The residualRoadWidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $residualRoadWidth;
    /**
     * The trafficConstrictionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficConstrictionType;
    /**
     * The delays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Delays
     */
    public $delays;
    /**
     * The impactExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $impactExtension;
    /**
     * Constructor method for Impact
     * @uses Impact::setCapacityRemaining()
     * @uses Impact::setNumberOfLanesRestricted()
     * @uses Impact::setNumberOfOperationalLanes()
     * @uses Impact::setOriginalNumberOfLanes()
     * @uses Impact::setResidualRoadWidth()
     * @uses Impact::setTrafficConstrictionType()
     * @uses Impact::setDelays()
     * @uses Impact::setImpactExtension()
     * @param float $capacityRemaining
     * @param int $numberOfLanesRestricted
     * @param int $numberOfOperationalLanes
     * @param int $originalNumberOfLanes
     * @param float $residualRoadWidth
     * @param string $trafficConstrictionType
     * @param \StructType\Delays $delays
     * @param \StructType\ExtensionType $impactExtension
     */
    public function __construct($capacityRemaining = null, $numberOfLanesRestricted = null, $numberOfOperationalLanes = null, $originalNumberOfLanes = null, $residualRoadWidth = null, $trafficConstrictionType = null, \StructType\Delays $delays = null, \StructType\ExtensionType $impactExtension = null)
    {
        $this
            ->setCapacityRemaining($capacityRemaining)
            ->setNumberOfLanesRestricted($numberOfLanesRestricted)
            ->setNumberOfOperationalLanes($numberOfOperationalLanes)
            ->setOriginalNumberOfLanes($originalNumberOfLanes)
            ->setResidualRoadWidth($residualRoadWidth)
            ->setTrafficConstrictionType($trafficConstrictionType)
            ->setDelays($delays)
            ->setImpactExtension($impactExtension);
    }
    /**
     * Get capacityRemaining value
     * @return float|null
     */
    public function getCapacityRemaining()
    {
        return $this->capacityRemaining;
    }
    /**
     * Set capacityRemaining value
     * @param float $capacityRemaining
     * @return \StructType\Impact
     */
    public function setCapacityRemaining($capacityRemaining = null)
    {
        $this->capacityRemaining = $capacityRemaining;
        return $this;
    }
    /**
     * Get numberOfLanesRestricted value
     * @return int|null
     */
    public function getNumberOfLanesRestricted()
    {
        return $this->numberOfLanesRestricted;
    }
    /**
     * Set numberOfLanesRestricted value
     * @param int $numberOfLanesRestricted
     * @return \StructType\Impact
     */
    public function setNumberOfLanesRestricted($numberOfLanesRestricted = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLanesRestricted) && !is_numeric($numberOfLanesRestricted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfLanesRestricted)), __LINE__);
        }
        $this->numberOfLanesRestricted = $numberOfLanesRestricted;
        return $this;
    }
    /**
     * Get numberOfOperationalLanes value
     * @return int|null
     */
    public function getNumberOfOperationalLanes()
    {
        return $this->numberOfOperationalLanes;
    }
    /**
     * Set numberOfOperationalLanes value
     * @param int $numberOfOperationalLanes
     * @return \StructType\Impact
     */
    public function setNumberOfOperationalLanes($numberOfOperationalLanes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOperationalLanes) && !is_numeric($numberOfOperationalLanes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfOperationalLanes)), __LINE__);
        }
        $this->numberOfOperationalLanes = $numberOfOperationalLanes;
        return $this;
    }
    /**
     * Get originalNumberOfLanes value
     * @return int|null
     */
    public function getOriginalNumberOfLanes()
    {
        return $this->originalNumberOfLanes;
    }
    /**
     * Set originalNumberOfLanes value
     * @param int $originalNumberOfLanes
     * @return \StructType\Impact
     */
    public function setOriginalNumberOfLanes($originalNumberOfLanes = null)
    {
        // validation for constraint: int
        if (!is_null($originalNumberOfLanes) && !is_numeric($originalNumberOfLanes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originalNumberOfLanes)), __LINE__);
        }
        $this->originalNumberOfLanes = $originalNumberOfLanes;
        return $this;
    }
    /**
     * Get residualRoadWidth value
     * @return float|null
     */
    public function getResidualRoadWidth()
    {
        return $this->residualRoadWidth;
    }
    /**
     * Set residualRoadWidth value
     * @param float $residualRoadWidth
     * @return \StructType\Impact
     */
    public function setResidualRoadWidth($residualRoadWidth = null)
    {
        $this->residualRoadWidth = $residualRoadWidth;
        return $this;
    }
    /**
     * Get trafficConstrictionType value
     * @return string|null
     */
    public function getTrafficConstrictionType()
    {
        return $this->trafficConstrictionType;
    }
    /**
     * Set trafficConstrictionType value
     * @uses \EnumType\TrafficConstrictionTypeEnum::valueIsValid()
     * @uses \EnumType\TrafficConstrictionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficConstrictionType
     * @return \StructType\Impact
     */
    public function setTrafficConstrictionType($trafficConstrictionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficConstrictionTypeEnum::valueIsValid($trafficConstrictionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficConstrictionType, implode(', ', \EnumType\TrafficConstrictionTypeEnum::getValidValues())), __LINE__);
        }
        $this->trafficConstrictionType = $trafficConstrictionType;
        return $this;
    }
    /**
     * Get delays value
     * @return \StructType\Delays|null
     */
    public function getDelays()
    {
        return $this->delays;
    }
    /**
     * Set delays value
     * @param \StructType\Delays $delays
     * @return \StructType\Impact
     */
    public function setDelays(\StructType\Delays $delays = null)
    {
        $this->delays = $delays;
        return $this;
    }
    /**
     * Get impactExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getImpactExtension()
    {
        return $this->impactExtension;
    }
    /**
     * Set impactExtension value
     * @param \StructType\ExtensionType $impactExtension
     * @return \StructType\Impact
     */
    public function setImpactExtension(\StructType\ExtensionType $impactExtension = null)
    {
        $this->impactExtension = $impactExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Impact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
