<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeaviestAxleWeightCharacteristic StructType
 * @subpackage Structs
 */
class HeaviestAxleWeightCharacteristic extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comparisonOperator;
    /**
     * The heaviestAxleWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $heaviestAxleWeight;
    /**
     * The heaviestAxleWeightCharacteristicExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $heaviestAxleWeightCharacteristicExtension;
    /**
     * Constructor method for HeaviestAxleWeightCharacteristic
     * @uses HeaviestAxleWeightCharacteristic::setComparisonOperator()
     * @uses HeaviestAxleWeightCharacteristic::setHeaviestAxleWeight()
     * @uses HeaviestAxleWeightCharacteristic::setHeaviestAxleWeightCharacteristicExtension()
     * @param string $comparisonOperator
     * @param float $heaviestAxleWeight
     * @param \StructType\ExtensionType $heaviestAxleWeightCharacteristicExtension
     */
    public function __construct($comparisonOperator = null, $heaviestAxleWeight = null, \StructType\ExtensionType $heaviestAxleWeightCharacteristicExtension = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setHeaviestAxleWeight($heaviestAxleWeight)
            ->setHeaviestAxleWeightCharacteristicExtension($heaviestAxleWeightCharacteristicExtension);
    }
    /**
     * Get comparisonOperator value
     * @return string
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperatorEnum::valueIsValid()
     * @uses \EnumType\ComparisonOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\HeaviestAxleWeightCharacteristic
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperatorEnum::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperatorEnum::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get heaviestAxleWeight value
     * @return float
     */
    public function getHeaviestAxleWeight()
    {
        return $this->heaviestAxleWeight;
    }
    /**
     * Set heaviestAxleWeight value
     * @param float $heaviestAxleWeight
     * @return \StructType\HeaviestAxleWeightCharacteristic
     */
    public function setHeaviestAxleWeight($heaviestAxleWeight = null)
    {
        $this->heaviestAxleWeight = $heaviestAxleWeight;
        return $this;
    }
    /**
     * Get heaviestAxleWeightCharacteristicExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getHeaviestAxleWeightCharacteristicExtension()
    {
        return $this->heaviestAxleWeightCharacteristicExtension;
    }
    /**
     * Set heaviestAxleWeightCharacteristicExtension value
     * @param \StructType\ExtensionType $heaviestAxleWeightCharacteristicExtension
     * @return \StructType\HeaviestAxleWeightCharacteristic
     */
    public function setHeaviestAxleWeightCharacteristicExtension(\StructType\ExtensionType $heaviestAxleWeightCharacteristicExtension = null)
    {
        $this->heaviestAxleWeightCharacteristicExtension = $heaviestAxleWeightCharacteristicExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HeaviestAxleWeightCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
