<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeartbeatNotificationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Service Heartbeat Notification.
 * @subpackage Structs
 */
class HeartbeatNotificationStructure extends ProducerRequestEndpointStructure
{
    /**
     * The Status
     * @var bool
     */
    public $Status;
    /**
     * The DataReady
     * @var bool
     */
    public $DataReady;
    /**
     * The ErrorCondition
     * @var \StructType\ErrorCondition
     */
    public $ErrorCondition;
    /**
     * The ValidUntil
     * @var string
     */
    public $ValidUntil;
    /**
     * The ShortestPossibleCycle
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ShortestPossibleCycle;
    /**
     * The ServiceStartedTime
     * @var string
     */
    public $ServiceStartedTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for HeartbeatNotificationStructure
     * @uses HeartbeatNotificationStructure::setStatus()
     * @uses HeartbeatNotificationStructure::setDataReady()
     * @uses HeartbeatNotificationStructure::setErrorCondition()
     * @uses HeartbeatNotificationStructure::setValidUntil()
     * @uses HeartbeatNotificationStructure::setShortestPossibleCycle()
     * @uses HeartbeatNotificationStructure::setServiceStartedTime()
     * @uses HeartbeatNotificationStructure::setExtensions()
     * @param bool $status
     * @param bool $dataReady
     * @param \StructType\ErrorCondition $errorCondition
     * @param string $validUntil
     * @param string $shortestPossibleCycle
     * @param string $serviceStartedTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($status = null, $dataReady = null, \StructType\ErrorCondition $errorCondition = null, $validUntil = null, $shortestPossibleCycle = null, $serviceStartedTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStatus($status)
            ->setDataReady($dataReady)
            ->setErrorCondition($errorCondition)
            ->setValidUntil($validUntil)
            ->setShortestPossibleCycle($shortestPossibleCycle)
            ->setServiceStartedTime($serviceStartedTime)
            ->setExtensions($extensions);
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DataReady value
     * @return bool|null
     */
    public function getDataReady()
    {
        return $this->DataReady;
    }
    /**
     * Set DataReady value
     * @param bool $dataReady
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setDataReady($dataReady = null)
    {
        // validation for constraint: boolean
        if (!is_null($dataReady) && !is_bool($dataReady)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dataReady)), __LINE__);
        }
        $this->DataReady = $dataReady;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ErrorCondition|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ErrorCondition $errorCondition
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setErrorCondition(\StructType\ErrorCondition $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Get ValidUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->ValidUntil;
    }
    /**
     * Set ValidUntil value
     * @param string $validUntil
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntil)), __LINE__);
        }
        $this->ValidUntil = $validUntil;
        return $this;
    }
    /**
     * Get ShortestPossibleCycle value
     * @return string|null
     */
    public function getShortestPossibleCycle()
    {
        return $this->ShortestPossibleCycle;
    }
    /**
     * Set ShortestPossibleCycle value
     * @param string $shortestPossibleCycle
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setShortestPossibleCycle($shortestPossibleCycle = null)
    {
        // validation for constraint: string
        if (!is_null($shortestPossibleCycle) && !is_string($shortestPossibleCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortestPossibleCycle)), __LINE__);
        }
        $this->ShortestPossibleCycle = $shortestPossibleCycle;
        return $this;
    }
    /**
     * Get ServiceStartedTime value
     * @return string|null
     */
    public function getServiceStartedTime()
    {
        return $this->ServiceStartedTime;
    }
    /**
     * Set ServiceStartedTime value
     * @param string $serviceStartedTime
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setServiceStartedTime($serviceStartedTime = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStartedTime) && !is_string($serviceStartedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceStartedTime)), __LINE__);
        }
        $this->ServiceStartedTime = $serviceStartedTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\HeartbeatNotificationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HeartbeatNotificationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
