<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HalfOpenTimestampOutputRangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a range of date times. Start time must be specified, end time is optional.
 * @subpackage Structs
 */
class HalfOpenTimestampOutputRangeStructure extends AbstractStructBase
{
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - documentation: The (inclusive) start time stamp.
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - documentation: The (inclusive) end time stamp. If omitted, the range end is open-ended, that is, it should be interpreted as defined by end time status.
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * The EndTimeStatus
     * Meta informations extracted from the WSDL
     * - default: undefined
     * - documentation: If end time not provided, whethhr to interpret range as long, term, short term or unknown length of situation. Default is unknown. (Siri 2.0++)
     * - minOccurs: 0
     * @var string
     */
    public $EndTimeStatus;
    /**
     * Constructor method for HalfOpenTimestampOutputRangeStructure
     * @uses HalfOpenTimestampOutputRangeStructure::setStartTime()
     * @uses HalfOpenTimestampOutputRangeStructure::setEndTime()
     * @uses HalfOpenTimestampOutputRangeStructure::setEndTimeStatus()
     * @param string $startTime
     * @param string $endTime
     * @param string $endTimeStatus
     */
    public function __construct($startTime = null, $endTime = null, $endTimeStatus = 'undefined')
    {
        $this
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setEndTimeStatus($endTimeStatus);
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get EndTimeStatus value
     * @return string|null
     */
    public function getEndTimeStatus()
    {
        return $this->EndTimeStatus;
    }
    /**
     * Set EndTimeStatus value
     * @uses \EnumType\EndTimeStatusEnumeration::valueIsValid()
     * @uses \EnumType\EndTimeStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTimeStatus
     * @return \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public function setEndTimeStatus($endTimeStatus = 'undefined')
    {
        // validation for constraint: enumeration
        if (!\EnumType\EndTimeStatusEnumeration::valueIsValid($endTimeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endTimeStatus, implode(', ', \EnumType\EndTimeStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->EndTimeStatus = $endTimeStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
