<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GrossWeightCharacteristic StructType
 * @subpackage Structs
 */
class GrossWeightCharacteristic extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comparisonOperator;
    /**
     * The grossVehicleWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $grossVehicleWeight;
    /**
     * The grossWeightCharacteristicExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $grossWeightCharacteristicExtension;
    /**
     * Constructor method for GrossWeightCharacteristic
     * @uses GrossWeightCharacteristic::setComparisonOperator()
     * @uses GrossWeightCharacteristic::setGrossVehicleWeight()
     * @uses GrossWeightCharacteristic::setGrossWeightCharacteristicExtension()
     * @param string $comparisonOperator
     * @param float $grossVehicleWeight
     * @param \StructType\ExtensionType $grossWeightCharacteristicExtension
     */
    public function __construct($comparisonOperator = null, $grossVehicleWeight = null, \StructType\ExtensionType $grossWeightCharacteristicExtension = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setGrossVehicleWeight($grossVehicleWeight)
            ->setGrossWeightCharacteristicExtension($grossWeightCharacteristicExtension);
    }
    /**
     * Get comparisonOperator value
     * @return string
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperatorEnum::valueIsValid()
     * @uses \EnumType\ComparisonOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\GrossWeightCharacteristic
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperatorEnum::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperatorEnum::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get grossVehicleWeight value
     * @return float
     */
    public function getGrossVehicleWeight()
    {
        return $this->grossVehicleWeight;
    }
    /**
     * Set grossVehicleWeight value
     * @param float $grossVehicleWeight
     * @return \StructType\GrossWeightCharacteristic
     */
    public function setGrossVehicleWeight($grossVehicleWeight = null)
    {
        $this->grossVehicleWeight = $grossVehicleWeight;
        return $this;
    }
    /**
     * Get grossWeightCharacteristicExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGrossWeightCharacteristicExtension()
    {
        return $this->grossWeightCharacteristicExtension;
    }
    /**
     * Set grossWeightCharacteristicExtension value
     * @param \StructType\ExtensionType $grossWeightCharacteristicExtension
     * @return \StructType\GrossWeightCharacteristic
     */
    public function setGrossWeightCharacteristicExtension(\StructType\ExtensionType $grossWeightCharacteristicExtension = null)
    {
        $this->grossWeightCharacteristicExtension = $grossWeightCharacteristicExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GrossWeightCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
