<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericSituationRecord StructType
 * @subpackage Structs
 */
abstract class GenericSituationRecord extends SituationRecord
{
    /**
     * The genericSituationRecordName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $genericSituationRecordName;
    /**
     * The genericSituationRecordExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $genericSituationRecordExtension;
    /**
     * Constructor method for GenericSituationRecord
     * @uses GenericSituationRecord::setGenericSituationRecordName()
     * @uses GenericSituationRecord::setGenericSituationRecordExtension()
     * @param string $genericSituationRecordName
     * @param \StructType\ExtensionType $genericSituationRecordExtension
     */
    public function __construct($genericSituationRecordName = null, \StructType\ExtensionType $genericSituationRecordExtension = null)
    {
        $this
            ->setGenericSituationRecordName($genericSituationRecordName)
            ->setGenericSituationRecordExtension($genericSituationRecordExtension);
    }
    /**
     * Get genericSituationRecordName value
     * @return string
     */
    public function getGenericSituationRecordName()
    {
        return $this->genericSituationRecordName;
    }
    /**
     * Set genericSituationRecordName value
     * @param string $genericSituationRecordName
     * @return \StructType\GenericSituationRecord
     */
    public function setGenericSituationRecordName($genericSituationRecordName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($genericSituationRecordName) && strlen($genericSituationRecordName) > 1024) || (is_array($genericSituationRecordName) && count($genericSituationRecordName) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($genericSituationRecordName) ? strlen($genericSituationRecordName) : count($genericSituationRecordName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($genericSituationRecordName) && !is_string($genericSituationRecordName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($genericSituationRecordName)), __LINE__);
        }
        $this->genericSituationRecordName = $genericSituationRecordName;
        return $this;
    }
    /**
     * Get genericSituationRecordExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGenericSituationRecordExtension()
    {
        return $this->genericSituationRecordExtension;
    }
    /**
     * Set genericSituationRecordExtension value
     * @param \StructType\ExtensionType $genericSituationRecordExtension
     * @return \StructType\GenericSituationRecord
     */
    public function setGenericSituationRecordExtension(\StructType\ExtensionType $genericSituationRecordExtension = null)
    {
        $this->genericSituationRecordExtension = $genericSituationRecordExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericSituationRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
