<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralObstruction StructType
 * @subpackage Structs
 */
class GeneralObstruction extends Obstruction
{
    /**
     * The obstructionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $obstructionType;
    /**
     * The groupOfPeopleInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupOfPeopleInvolved[]
     */
    public $groupOfPeopleInvolved;
    /**
     * The generalObstructionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $generalObstructionExtension;
    /**
     * Constructor method for GeneralObstruction
     * @uses GeneralObstruction::setObstructionType()
     * @uses GeneralObstruction::setGroupOfPeopleInvolved()
     * @uses GeneralObstruction::setGeneralObstructionExtension()
     * @param string[] $obstructionType
     * @param \StructType\GroupOfPeopleInvolved[] $groupOfPeopleInvolved
     * @param \StructType\ExtensionType $generalObstructionExtension
     */
    public function __construct(array $obstructionType = array(), array $groupOfPeopleInvolved = array(), \StructType\ExtensionType $generalObstructionExtension = null)
    {
        $this
            ->setObstructionType($obstructionType)
            ->setGroupOfPeopleInvolved($groupOfPeopleInvolved)
            ->setGeneralObstructionExtension($generalObstructionExtension);
    }
    /**
     * Get obstructionType value
     * @return string[]
     */
    public function getObstructionType()
    {
        return $this->obstructionType;
    }
    /**
     * Set obstructionType value
     * @uses \EnumType\ObstructionTypeEnum::valueIsValid()
     * @uses \EnumType\ObstructionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $obstructionType
     * @return \StructType\GeneralObstruction
     */
    public function setObstructionType(array $obstructionType = array())
    {
        $invalidValues = array();
        foreach ($obstructionType as $generalObstructionObstructionTypeItem) {
            if (!\EnumType\ObstructionTypeEnum::valueIsValid($generalObstructionObstructionTypeItem)) {
                $invalidValues[] = var_export($generalObstructionObstructionTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ObstructionTypeEnum::getValidValues())), __LINE__);
        }
        $this->obstructionType = $obstructionType;
        return $this;
    }
    /**
     * Add item to obstructionType value
     * @uses \EnumType\ObstructionTypeEnum::valueIsValid()
     * @uses \EnumType\ObstructionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GeneralObstruction
     */
    public function addToObstructionType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObstructionTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ObstructionTypeEnum::getValidValues())), __LINE__);
        }
        $this->obstructionType[] = $item;
        return $this;
    }
    /**
     * Get groupOfPeopleInvolved value
     * @return \StructType\GroupOfPeopleInvolved[]|null
     */
    public function getGroupOfPeopleInvolved()
    {
        return $this->groupOfPeopleInvolved;
    }
    /**
     * Set groupOfPeopleInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOfPeopleInvolved[] $groupOfPeopleInvolved
     * @return \StructType\GeneralObstruction
     */
    public function setGroupOfPeopleInvolved(array $groupOfPeopleInvolved = array())
    {
        foreach ($groupOfPeopleInvolved as $generalObstructionGroupOfPeopleInvolvedItem) {
            // validation for constraint: itemType
            if (!$generalObstructionGroupOfPeopleInvolvedItem instanceof \StructType\GroupOfPeopleInvolved) {
                throw new \InvalidArgumentException(sprintf('The groupOfPeopleInvolved property can only contain items of \StructType\GroupOfPeopleInvolved, "%s" given', is_object($generalObstructionGroupOfPeopleInvolvedItem) ? get_class($generalObstructionGroupOfPeopleInvolvedItem) : gettype($generalObstructionGroupOfPeopleInvolvedItem)), __LINE__);
            }
        }
        $this->groupOfPeopleInvolved = $groupOfPeopleInvolved;
        return $this;
    }
    /**
     * Add item to groupOfPeopleInvolved value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOfPeopleInvolved $item
     * @return \StructType\GeneralObstruction
     */
    public function addToGroupOfPeopleInvolved(\StructType\GroupOfPeopleInvolved $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupOfPeopleInvolved) {
            throw new \InvalidArgumentException(sprintf('The groupOfPeopleInvolved property can only contain items of \StructType\GroupOfPeopleInvolved, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->groupOfPeopleInvolved[] = $item;
        return $this;
    }
    /**
     * Get generalObstructionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGeneralObstructionExtension()
    {
        return $this->generalObstructionExtension;
    }
    /**
     * Set generalObstructionExtension value
     * @param \StructType\ExtensionType $generalObstructionExtension
     * @return \StructType\GeneralObstruction
     */
    public function setGeneralObstructionExtension(\StructType\ExtensionType $generalObstructionExtension = null)
    {
        $this->generalObstructionExtension = $generalObstructionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralObstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
