<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralNetworkManagement StructType
 * @subpackage Structs
 */
class GeneralNetworkManagement extends NetworkManagement
{
    /**
     * The generalNetworkManagementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $generalNetworkManagementType;
    /**
     * The trafficManuallyDirectedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficManuallyDirectedBy;
    /**
     * The generalNetworkManagementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $generalNetworkManagementExtension;
    /**
     * Constructor method for GeneralNetworkManagement
     * @uses GeneralNetworkManagement::setGeneralNetworkManagementType()
     * @uses GeneralNetworkManagement::setTrafficManuallyDirectedBy()
     * @uses GeneralNetworkManagement::setGeneralNetworkManagementExtension()
     * @param string $generalNetworkManagementType
     * @param string $trafficManuallyDirectedBy
     * @param \StructType\ExtensionType $generalNetworkManagementExtension
     */
    public function __construct($generalNetworkManagementType = null, $trafficManuallyDirectedBy = null, \StructType\ExtensionType $generalNetworkManagementExtension = null)
    {
        $this
            ->setGeneralNetworkManagementType($generalNetworkManagementType)
            ->setTrafficManuallyDirectedBy($trafficManuallyDirectedBy)
            ->setGeneralNetworkManagementExtension($generalNetworkManagementExtension);
    }
    /**
     * Get generalNetworkManagementType value
     * @return string
     */
    public function getGeneralNetworkManagementType()
    {
        return $this->generalNetworkManagementType;
    }
    /**
     * Set generalNetworkManagementType value
     * @uses \EnumType\GeneralNetworkManagementTypeEnum::valueIsValid()
     * @uses \EnumType\GeneralNetworkManagementTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generalNetworkManagementType
     * @return \StructType\GeneralNetworkManagement
     */
    public function setGeneralNetworkManagementType($generalNetworkManagementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GeneralNetworkManagementTypeEnum::valueIsValid($generalNetworkManagementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $generalNetworkManagementType, implode(', ', \EnumType\GeneralNetworkManagementTypeEnum::getValidValues())), __LINE__);
        }
        $this->generalNetworkManagementType = $generalNetworkManagementType;
        return $this;
    }
    /**
     * Get trafficManuallyDirectedBy value
     * @return string|null
     */
    public function getTrafficManuallyDirectedBy()
    {
        return $this->trafficManuallyDirectedBy;
    }
    /**
     * Set trafficManuallyDirectedBy value
     * @uses \EnumType\PersonCategoryEnum::valueIsValid()
     * @uses \EnumType\PersonCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficManuallyDirectedBy
     * @return \StructType\GeneralNetworkManagement
     */
    public function setTrafficManuallyDirectedBy($trafficManuallyDirectedBy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonCategoryEnum::valueIsValid($trafficManuallyDirectedBy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficManuallyDirectedBy, implode(', ', \EnumType\PersonCategoryEnum::getValidValues())), __LINE__);
        }
        $this->trafficManuallyDirectedBy = $trafficManuallyDirectedBy;
        return $this;
    }
    /**
     * Get generalNetworkManagementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGeneralNetworkManagementExtension()
    {
        return $this->generalNetworkManagementExtension;
    }
    /**
     * Set generalNetworkManagementExtension value
     * @param \StructType\ExtensionType $generalNetworkManagementExtension
     * @return \StructType\GeneralNetworkManagement
     */
    public function setGeneralNetworkManagementExtension(\StructType\ExtensionType $generalNetworkManagementExtension = null)
    {
        $this->generalNetworkManagementExtension = $generalNetworkManagementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralNetworkManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
