<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralMessageRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Service Request for General Messages.
 * @subpackage Structs
 */
class GeneralMessageRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The InfoChannelRef
     * @var \StructType\InfoChannelRefStructure
     */
    public $InfoChannelRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for GeneralMessageRequestStructure
     * @uses GeneralMessageRequestStructure::setInfoChannelRef()
     * @uses GeneralMessageRequestStructure::setLanguage()
     * @uses GeneralMessageRequestStructure::setExtensions()
     * @uses GeneralMessageRequestStructure::setVersion()
     * @param \StructType\InfoChannelRefStructure $infoChannelRef
     * @param string $language
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\InfoChannelRefStructure $infoChannelRef = null, $language = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setInfoChannelRef($infoChannelRef)
            ->setLanguage($language)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get InfoChannelRef value
     * @return \StructType\InfoChannelRefStructure|null
     */
    public function getInfoChannelRef()
    {
        return $this->InfoChannelRef;
    }
    /**
     * Set InfoChannelRef value
     * @param \StructType\InfoChannelRefStructure $infoChannelRef
     * @return \StructType\GeneralMessageRequestStructure
     */
    public function setInfoChannelRef(\StructType\InfoChannelRefStructure $infoChannelRef = null)
    {
        $this->InfoChannelRef = $infoChannelRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GeneralMessageRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\GeneralMessageRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\GeneralMessageRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralMessageRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
