<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterReference StructType
 * @subpackage Structs
 */
class FilterReference extends AbstractStructBase
{
    /**
     * The keyFilterReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $keyFilterReference;
    /**
     * The deleteFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $deleteFilter;
    /**
     * The filterOperationApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $filterOperationApproved;
    /**
     * The filterReferenceExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $filterReferenceExtension;
    /**
     * Constructor method for FilterReference
     * @uses FilterReference::setKeyFilterReference()
     * @uses FilterReference::setDeleteFilter()
     * @uses FilterReference::setFilterOperationApproved()
     * @uses FilterReference::setFilterReferenceExtension()
     * @param string $keyFilterReference
     * @param bool $deleteFilter
     * @param bool $filterOperationApproved
     * @param \StructType\ExtensionType $filterReferenceExtension
     */
    public function __construct($keyFilterReference = null, $deleteFilter = null, $filterOperationApproved = null, \StructType\ExtensionType $filterReferenceExtension = null)
    {
        $this
            ->setKeyFilterReference($keyFilterReference)
            ->setDeleteFilter($deleteFilter)
            ->setFilterOperationApproved($filterOperationApproved)
            ->setFilterReferenceExtension($filterReferenceExtension);
    }
    /**
     * Get keyFilterReference value
     * @return string
     */
    public function getKeyFilterReference()
    {
        return $this->keyFilterReference;
    }
    /**
     * Set keyFilterReference value
     * @param string $keyFilterReference
     * @return \StructType\FilterReference
     */
    public function setKeyFilterReference($keyFilterReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($keyFilterReference) && strlen($keyFilterReference) > 1024) || (is_array($keyFilterReference) && count($keyFilterReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($keyFilterReference) ? strlen($keyFilterReference) : count($keyFilterReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($keyFilterReference) && !is_string($keyFilterReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyFilterReference)), __LINE__);
        }
        $this->keyFilterReference = $keyFilterReference;
        return $this;
    }
    /**
     * Get deleteFilter value
     * @return bool|null
     */
    public function getDeleteFilter()
    {
        return $this->deleteFilter;
    }
    /**
     * Set deleteFilter value
     * @param bool $deleteFilter
     * @return \StructType\FilterReference
     */
    public function setDeleteFilter($deleteFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteFilter) && !is_bool($deleteFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleteFilter)), __LINE__);
        }
        $this->deleteFilter = $deleteFilter;
        return $this;
    }
    /**
     * Get filterOperationApproved value
     * @return bool|null
     */
    public function getFilterOperationApproved()
    {
        return $this->filterOperationApproved;
    }
    /**
     * Set filterOperationApproved value
     * @param bool $filterOperationApproved
     * @return \StructType\FilterReference
     */
    public function setFilterOperationApproved($filterOperationApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterOperationApproved) && !is_bool($filterOperationApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterOperationApproved)), __LINE__);
        }
        $this->filterOperationApproved = $filterOperationApproved;
        return $this;
    }
    /**
     * Get filterReferenceExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getFilterReferenceExtension()
    {
        return $this->filterReferenceExtension;
    }
    /**
     * Set filterReferenceExtension value
     * @param \StructType\ExtensionType $filterReferenceExtension
     * @return \StructType\FilterReference
     */
    public function setFilterReferenceExtension(\StructType\ExtensionType $filterReferenceExtension = null)
    {
        $this->filterReferenceExtension = $filterReferenceExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
