<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Features StructType
 * Meta informations extracted from the WSDL
 * - documentation: Features of service. | Service features of stop. Detail level is 'full' | GIS Features that this element projects onto.
 * @subpackage Structs
 */
class Features extends AbstractStructBase
{
    /**
     * The ServiceFeature
     * Meta informations extracted from the WSDL
     * - documentation: Description of Service features of stop.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceFeatureStructure
     */
    public $ServiceFeature;
    /**
     * The ServiceFeatureRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The GisFeatureRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of FEATURE in a GIS data system.
     * - maxOccurs: unbounded
     * @var \StructType\FeatureRefStructure[]
     */
    public $GisFeatureRef;
    /**
     * The Feature
     * Meta informations extracted from the WSDL
     * - documentation: Description of the feauture of the facility. Several features may be associated to a single facility.
     * - maxOccurs: unbounded
     * @var \StructType\AllFacilitiesFeatureStructure[]
     */
    public $Feature;
    /**
     * Constructor method for Features
     * @uses Features::setServiceFeature()
     * @uses Features::setServiceFeatureRef()
     * @uses Features::setGisFeatureRef()
     * @uses Features::setFeature()
     * @param \StructType\ServiceFeatureStructure $serviceFeature
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\FeatureRefStructure[] $gisFeatureRef
     * @param \StructType\AllFacilitiesFeatureStructure[] $feature
     */
    public function __construct(\StructType\ServiceFeatureStructure $serviceFeature = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, array $gisFeatureRef = array(), array $feature = array())
    {
        $this
            ->setServiceFeature($serviceFeature)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setGisFeatureRef($gisFeatureRef)
            ->setFeature($feature);
    }
    /**
     * Get ServiceFeature value
     * @return \StructType\ServiceFeatureStructure
     */
    public function getServiceFeature()
    {
        return $this->ServiceFeature;
    }
    /**
     * Set ServiceFeature value
     * @param \StructType\ServiceFeatureStructure $serviceFeature
     * @return \StructType\Features
     */
    public function setServiceFeature(\StructType\ServiceFeatureStructure $serviceFeature = null)
    {
        $this->ServiceFeature = $serviceFeature;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\Features
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get GisFeatureRef value
     * @return \StructType\FeatureRefStructure[]|null
     */
    public function getGisFeatureRef()
    {
        return $this->GisFeatureRef;
    }
    /**
     * Set GisFeatureRef value
     * @throws \InvalidArgumentException
     * @param \StructType\FeatureRefStructure[] $gisFeatureRef
     * @return \StructType\Features
     */
    public function setGisFeatureRef(array $gisFeatureRef = array())
    {
        foreach ($gisFeatureRef as $featuresGisFeatureRefItem) {
            // validation for constraint: itemType
            if (!$featuresGisFeatureRefItem instanceof \StructType\FeatureRefStructure) {
                throw new \InvalidArgumentException(sprintf('The GisFeatureRef property can only contain items of \StructType\FeatureRefStructure, "%s" given', is_object($featuresGisFeatureRefItem) ? get_class($featuresGisFeatureRefItem) : gettype($featuresGisFeatureRefItem)), __LINE__);
            }
        }
        $this->GisFeatureRef = $gisFeatureRef;
        return $this;
    }
    /**
     * Add item to GisFeatureRef value
     * @throws \InvalidArgumentException
     * @param \StructType\FeatureRefStructure $item
     * @return \StructType\Features
     */
    public function addToGisFeatureRef(\StructType\FeatureRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeatureRefStructure) {
            throw new \InvalidArgumentException(sprintf('The GisFeatureRef property can only contain items of \StructType\FeatureRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GisFeatureRef[] = $item;
        return $this;
    }
    /**
     * Get Feature value
     * @return \StructType\AllFacilitiesFeatureStructure[]|null
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @throws \InvalidArgumentException
     * @param \StructType\AllFacilitiesFeatureStructure[] $feature
     * @return \StructType\Features
     */
    public function setFeature(array $feature = array())
    {
        foreach ($feature as $featuresFeatureItem) {
            // validation for constraint: itemType
            if (!$featuresFeatureItem instanceof \StructType\AllFacilitiesFeatureStructure) {
                throw new \InvalidArgumentException(sprintf('The Feature property can only contain items of \StructType\AllFacilitiesFeatureStructure, "%s" given', is_object($featuresFeatureItem) ? get_class($featuresFeatureItem) : gettype($featuresFeatureItem)), __LINE__);
            }
        }
        $this->Feature = $feature;
        return $this;
    }
    /**
     * Add item to Feature value
     * @throws \InvalidArgumentException
     * @param \StructType\AllFacilitiesFeatureStructure $item
     * @return \StructType\Features
     */
    public function addToFeature(\StructType\AllFacilitiesFeatureStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllFacilitiesFeatureStructure) {
            throw new \InvalidArgumentException(sprintf('The Feature property can only contain items of \StructType\AllFacilitiesFeatureStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Feature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Features
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
