<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for sescription the MONITORED FACILITY itself.
 * @subpackage Structs
 */
class FacilityStructure extends AbstractStructBase
{
    /**
     * The FacilityCode
     * Meta informations extracted from the WSDL
     * - documentation: Identfier of Facility. | Type for identifier of a Faclility.
     * - minOccurs: 0
     * @var string
     */
    public $FacilityCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Textual description of the facility. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Description;
    /**
     * The FacilityClass
     * Meta informations extracted from the WSDL
     * - documentation: Type of facility (several types may be associated to a single facility)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FacilityClass;
    /**
     * The Features
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Features
     */
    public $Features;
    /**
     * The OwnerRef
     * Meta informations extracted from the WSDL
     * - documentation: Refererence to identifier of owner of facility.
     * - minOccurs: 0
     * @var \StructType\OrganisationRefStructure
     */
    public $OwnerRef;
    /**
     * The OwnerName
     * Meta informations extracted from the WSDL
     * - documentation: Textual description of the owner of the facility.
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $OwnerName;
    /**
     * The ValidityCondition
     * Meta informations extracted from the WSDL
     * - documentation: When Facility is normally avaialble. If not specified, default is 'always'. Values are Logically ANDed together.
     * - minOccurs: 0
     * @var \StructType\MonitoringValidityConditionStructure
     */
    public $ValidityCondition;
    /**
     * The FacilityLocation
     * Meta informations extracted from the WSDL
     * - documentation: Describes where the facility is located. The location is a Transmodel object reference or an IFOPT object reference.
     * - minOccurs: 0
     * @var \StructType\FacilityLocationStructure
     */
    public $FacilityLocation;
    /**
     * The Limitations
     * @var \StructType\Limitations
     */
    public $Limitations;
    /**
     * The Suitabilities
     * @var \StructType\Suitabilities
     */
    public $Suitabilities;
    /**
     * The AccessibilityAssessment
     * Meta informations extracted from the WSDL
     * - documentation: Accessibility of the facility.
     * - minOccurs: 0
     * @var \StructType\AccessibilityAssessmentStructure
     */
    public $AccessibilityAssessment;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for FacilityStructure
     * @uses FacilityStructure::setFacilityCode()
     * @uses FacilityStructure::setDescription()
     * @uses FacilityStructure::setFacilityClass()
     * @uses FacilityStructure::setFeatures()
     * @uses FacilityStructure::setOwnerRef()
     * @uses FacilityStructure::setOwnerName()
     * @uses FacilityStructure::setValidityCondition()
     * @uses FacilityStructure::setFacilityLocation()
     * @uses FacilityStructure::setLimitations()
     * @uses FacilityStructure::setSuitabilities()
     * @uses FacilityStructure::setAccessibilityAssessment()
     * @uses FacilityStructure::setExtensions()
     * @param string $facilityCode
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @param string[] $facilityClass
     * @param \StructType\Features $features
     * @param \StructType\OrganisationRefStructure $ownerRef
     * @param \StructType\NaturalLanguageStringStructure $ownerName
     * @param \StructType\MonitoringValidityConditionStructure $validityCondition
     * @param \StructType\FacilityLocationStructure $facilityLocation
     * @param \StructType\Limitations $limitations
     * @param \StructType\Suitabilities $suitabilities
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($facilityCode = null, array $description = array(), array $facilityClass = array(), \StructType\Features $features = null, \StructType\OrganisationRefStructure $ownerRef = null, \StructType\NaturalLanguageStringStructure $ownerName = null, \StructType\MonitoringValidityConditionStructure $validityCondition = null, \StructType\FacilityLocationStructure $facilityLocation = null, \StructType\Limitations $limitations = null, \StructType\Suitabilities $suitabilities = null, \StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setFacilityCode($facilityCode)
            ->setDescription($description)
            ->setFacilityClass($facilityClass)
            ->setFeatures($features)
            ->setOwnerRef($ownerRef)
            ->setOwnerName($ownerName)
            ->setValidityCondition($validityCondition)
            ->setFacilityLocation($facilityLocation)
            ->setLimitations($limitations)
            ->setSuitabilities($suitabilities)
            ->setAccessibilityAssessment($accessibilityAssessment)
            ->setExtensions($extensions);
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \StructType\FacilityStructure
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @return \StructType\FacilityStructure
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $facilityStructureDescriptionItem) {
            // validation for constraint: itemType
            if (!$facilityStructureDescriptionItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($facilityStructureDescriptionItem) ? get_class($facilityStructureDescriptionItem) : gettype($facilityStructureDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\FacilityStructure
     */
    public function addToDescription(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get FacilityClass value
     * @return string[]|null
     */
    public function getFacilityClass()
    {
        return $this->FacilityClass;
    }
    /**
     * Set FacilityClass value
     * @uses \EnumType\FacilityCategoryEnumeration::valueIsValid()
     * @uses \EnumType\FacilityCategoryEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $facilityClass
     * @return \StructType\FacilityStructure
     */
    public function setFacilityClass(array $facilityClass = array())
    {
        $invalidValues = array();
        foreach ($facilityClass as $facilityStructureFacilityClassItem) {
            if (!\EnumType\FacilityCategoryEnumeration::valueIsValid($facilityStructureFacilityClassItem)) {
                $invalidValues[] = var_export($facilityStructureFacilityClassItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\FacilityCategoryEnumeration::getValidValues())), __LINE__);
        }
        $this->FacilityClass = $facilityClass;
        return $this;
    }
    /**
     * Add item to FacilityClass value
     * @uses \EnumType\FacilityCategoryEnumeration::valueIsValid()
     * @uses \EnumType\FacilityCategoryEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FacilityStructure
     */
    public function addToFacilityClass($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FacilityCategoryEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\FacilityCategoryEnumeration::getValidValues())), __LINE__);
        }
        $this->FacilityClass[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return \StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \StructType\Features $features
     * @return \StructType\FacilityStructure
     */
    public function setFeatures(\StructType\Features $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get OwnerRef value
     * @return \StructType\OrganisationRefStructure|null
     */
    public function getOwnerRef()
    {
        return $this->OwnerRef;
    }
    /**
     * Set OwnerRef value
     * @param \StructType\OrganisationRefStructure $ownerRef
     * @return \StructType\FacilityStructure
     */
    public function setOwnerRef(\StructType\OrganisationRefStructure $ownerRef = null)
    {
        $this->OwnerRef = $ownerRef;
        return $this;
    }
    /**
     * Get OwnerName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getOwnerName()
    {
        return $this->OwnerName;
    }
    /**
     * Set OwnerName value
     * @param \StructType\NaturalLanguageStringStructure $ownerName
     * @return \StructType\FacilityStructure
     */
    public function setOwnerName(\StructType\NaturalLanguageStringStructure $ownerName = null)
    {
        $this->OwnerName = $ownerName;
        return $this;
    }
    /**
     * Get ValidityCondition value
     * @return \StructType\MonitoringValidityConditionStructure|null
     */
    public function getValidityCondition()
    {
        return $this->ValidityCondition;
    }
    /**
     * Set ValidityCondition value
     * @param \StructType\MonitoringValidityConditionStructure $validityCondition
     * @return \StructType\FacilityStructure
     */
    public function setValidityCondition(\StructType\MonitoringValidityConditionStructure $validityCondition = null)
    {
        $this->ValidityCondition = $validityCondition;
        return $this;
    }
    /**
     * Get FacilityLocation value
     * @return \StructType\FacilityLocationStructure|null
     */
    public function getFacilityLocation()
    {
        return $this->FacilityLocation;
    }
    /**
     * Set FacilityLocation value
     * @param \StructType\FacilityLocationStructure $facilityLocation
     * @return \StructType\FacilityStructure
     */
    public function setFacilityLocation(\StructType\FacilityLocationStructure $facilityLocation = null)
    {
        $this->FacilityLocation = $facilityLocation;
        return $this;
    }
    /**
     * Get Limitations value
     * @return \StructType\Limitations|null
     */
    public function getLimitations()
    {
        return $this->Limitations;
    }
    /**
     * Set Limitations value
     * @param \StructType\Limitations $limitations
     * @return \StructType\FacilityStructure
     */
    public function setLimitations(\StructType\Limitations $limitations = null)
    {
        $this->Limitations = $limitations;
        return $this;
    }
    /**
     * Get Suitabilities value
     * @return \StructType\Suitabilities|null
     */
    public function getSuitabilities()
    {
        return $this->Suitabilities;
    }
    /**
     * Set Suitabilities value
     * @param \StructType\Suitabilities $suitabilities
     * @return \StructType\FacilityStructure
     */
    public function setSuitabilities(\StructType\Suitabilities $suitabilities = null)
    {
        $this->Suitabilities = $suitabilities;
        return $this;
    }
    /**
     * Get AccessibilityAssessment value
     * @return \StructType\AccessibilityAssessmentStructure|null
     */
    public function getAccessibilityAssessment()
    {
        return $this->AccessibilityAssessment;
    }
    /**
     * Set AccessibilityAssessment value
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @return \StructType\FacilityStructure
     */
    public function setAccessibilityAssessment(\StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null)
    {
        $this->AccessibilityAssessment = $accessibilityAssessment;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
