<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityStatusStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Descriprion of the status of a MONITORED FACILITY.
 * @subpackage Structs
 */
class FacilityStatusStructure extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Status of the facility.
     * @var string
     */
    public $Status;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Description of the facility Status. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Description;
    /**
     * The AccessibilityAssessment
     * Meta informations extracted from the WSDL
     * - documentation: Accessibility of the facility.
     * - minOccurs: 0
     * @var \StructType\AccessibilityAssessmentStructure
     */
    public $AccessibilityAssessment;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for FacilityStatusStructure
     * @uses FacilityStatusStructure::setStatus()
     * @uses FacilityStatusStructure::setDescription()
     * @uses FacilityStatusStructure::setAccessibilityAssessment()
     * @uses FacilityStatusStructure::setExtensions()
     * @param string $status
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($status = null, array $description = array(), \StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStatus($status)
            ->setDescription($description)
            ->setAccessibilityAssessment($accessibilityAssessment)
            ->setExtensions($extensions);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\FacilityStatusEnumeration::valueIsValid()
     * @uses \EnumType\FacilityStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\FacilityStatusStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FacilityStatusEnumeration::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\FacilityStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @return \StructType\FacilityStatusStructure
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $facilityStatusStructureDescriptionItem) {
            // validation for constraint: itemType
            if (!$facilityStatusStructureDescriptionItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($facilityStatusStructureDescriptionItem) ? get_class($facilityStatusStructureDescriptionItem) : gettype($facilityStatusStructureDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\FacilityStatusStructure
     */
    public function addToDescription(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get AccessibilityAssessment value
     * @return \StructType\AccessibilityAssessmentStructure|null
     */
    public function getAccessibilityAssessment()
    {
        return $this->AccessibilityAssessment;
    }
    /**
     * Set AccessibilityAssessment value
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @return \StructType\FacilityStatusStructure
     */
    public function setAccessibilityAssessment(\StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null)
    {
        $this->AccessibilityAssessment = $accessibilityAssessment;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityStatusStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityStatusStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
