<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityMonitoringSubscriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Subscription Request for Vehicle Monitoring Service.
 * @subpackage Structs
 */
class FacilityMonitoringSubscriptionStructure extends AbstractSubscriptionStructure
{
    /**
     * The FacilityMonitoringRequest
     * Meta informations extracted from the WSDL
     * - ref: FacilityMonitoringRequest
     * @var \StructType\FacilityMonitoringRequestStructure
     */
    public $FacilityMonitoringRequest;
    /**
     * The IncrementalUpdates
     * @var bool
     */
    public $IncrementalUpdates;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for FacilityMonitoringSubscriptionStructure
     * @uses FacilityMonitoringSubscriptionStructure::setFacilityMonitoringRequest()
     * @uses FacilityMonitoringSubscriptionStructure::setIncrementalUpdates()
     * @uses FacilityMonitoringSubscriptionStructure::setExtensions()
     * @param \StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest
     * @param bool $incrementalUpdates
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest = null, $incrementalUpdates = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setFacilityMonitoringRequest($facilityMonitoringRequest)
            ->setIncrementalUpdates($incrementalUpdates)
            ->setExtensions($extensions);
    }
    /**
     * Get FacilityMonitoringRequest value
     * @return \StructType\FacilityMonitoringRequestStructure|null
     */
    public function getFacilityMonitoringRequest()
    {
        return $this->FacilityMonitoringRequest;
    }
    /**
     * Set FacilityMonitoringRequest value
     * @param \StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest
     * @return \StructType\FacilityMonitoringSubscriptionStructure
     */
    public function setFacilityMonitoringRequest(\StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest = null)
    {
        $this->FacilityMonitoringRequest = $facilityMonitoringRequest;
        return $this;
    }
    /**
     * Get IncrementalUpdates value
     * @return bool|null
     */
    public function getIncrementalUpdates()
    {
        return $this->IncrementalUpdates;
    }
    /**
     * Set IncrementalUpdates value
     * @param bool $incrementalUpdates
     * @return \StructType\FacilityMonitoringSubscriptionStructure
     */
    public function setIncrementalUpdates($incrementalUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($incrementalUpdates) && !is_bool($incrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incrementalUpdates)), __LINE__);
        }
        $this->IncrementalUpdates = $incrementalUpdates;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityMonitoringSubscriptionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityMonitoringSubscriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
