<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityConditionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Description of any change concerning a MONITORED FACILITY New structure defined in SIRI XSD 1.1 for Faclities Management.
 * @subpackage Structs
 */
class FacilityConditionStructure extends AbstractStructBase
{
    /**
     * The Facility
     * Meta informations extracted from the WSDL
     * - documentation: Facility affected by condition.
     * @var \StructType\FacilityStructure
     */
    public $Facility;
    /**
     * The FacilityRef
     * Meta informations extracted from the WSDL
     * - ref: FacilityRef
     * @var \StructType\FacilityRefStructure
     */
    public $FacilityRef;
    /**
     * The FacilityStatus
     * Meta informations extracted from the WSDL
     * - documentation: Status of Facility.
     * @var \StructType\FacilityStatusStructure
     */
    public $FacilityStatus;
    /**
     * The SituationRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: SituationRef
     * @var \StructType\SituationRefStructure
     */
    public $SituationRef;
    /**
     * The Remedy
     * Meta informations extracted from the WSDL
     * - documentation: Setup action to remedy the change of the facility status (if partialy or totaly anavailable)
     * - minOccurs: 0
     * @var \StructType\RemedyStructure
     */
    public $Remedy;
    /**
     * The MonitoringInfo
     * Meta informations extracted from the WSDL
     * - documentation: Description of the mechanism used to monitor the change of the facility status.
     * - minOccurs: 0
     * @var \StructType\MonitoringInformationStructure
     */
    public $MonitoringInfo;
    /**
     * The ValidityPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Period (duration) of the status change for the facility.
     * - minOccurs: 0
     * @var \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public $ValidityPeriod;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for FacilityConditionStructure
     * @uses FacilityConditionStructure::setFacility()
     * @uses FacilityConditionStructure::setFacilityRef()
     * @uses FacilityConditionStructure::setFacilityStatus()
     * @uses FacilityConditionStructure::setSituationRef()
     * @uses FacilityConditionStructure::setRemedy()
     * @uses FacilityConditionStructure::setMonitoringInfo()
     * @uses FacilityConditionStructure::setValidityPeriod()
     * @uses FacilityConditionStructure::setExtensions()
     * @param \StructType\FacilityStructure $facility
     * @param \StructType\FacilityRefStructure $facilityRef
     * @param \StructType\FacilityStatusStructure $facilityStatus
     * @param \StructType\SituationRefStructure $situationRef
     * @param \StructType\RemedyStructure $remedy
     * @param \StructType\MonitoringInformationStructure $monitoringInfo
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\FacilityStructure $facility = null, \StructType\FacilityRefStructure $facilityRef = null, \StructType\FacilityStatusStructure $facilityStatus = null, \StructType\SituationRefStructure $situationRef = null, \StructType\RemedyStructure $remedy = null, \StructType\MonitoringInformationStructure $monitoringInfo = null, \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setFacility($facility)
            ->setFacilityRef($facilityRef)
            ->setFacilityStatus($facilityStatus)
            ->setSituationRef($situationRef)
            ->setRemedy($remedy)
            ->setMonitoringInfo($monitoringInfo)
            ->setValidityPeriod($validityPeriod)
            ->setExtensions($extensions);
    }
    /**
     * Get Facility value
     * @return \StructType\FacilityStructure|null
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * Set Facility value
     * @param \StructType\FacilityStructure $facility
     * @return \StructType\FacilityConditionStructure
     */
    public function setFacility(\StructType\FacilityStructure $facility = null)
    {
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Get FacilityRef value
     * @return \StructType\FacilityRefStructure|null
     */
    public function getFacilityRef()
    {
        return $this->FacilityRef;
    }
    /**
     * Set FacilityRef value
     * @param \StructType\FacilityRefStructure $facilityRef
     * @return \StructType\FacilityConditionStructure
     */
    public function setFacilityRef(\StructType\FacilityRefStructure $facilityRef = null)
    {
        $this->FacilityRef = $facilityRef;
        return $this;
    }
    /**
     * Get FacilityStatus value
     * @return \StructType\FacilityStatusStructure|null
     */
    public function getFacilityStatus()
    {
        return $this->FacilityStatus;
    }
    /**
     * Set FacilityStatus value
     * @param \StructType\FacilityStatusStructure $facilityStatus
     * @return \StructType\FacilityConditionStructure
     */
    public function setFacilityStatus(\StructType\FacilityStatusStructure $facilityStatus = null)
    {
        $this->FacilityStatus = $facilityStatus;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @param \StructType\SituationRefStructure $situationRef
     * @return \StructType\FacilityConditionStructure
     */
    public function setSituationRef(\StructType\SituationRefStructure $situationRef = null)
    {
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Get Remedy value
     * @return \StructType\RemedyStructure|null
     */
    public function getRemedy()
    {
        return $this->Remedy;
    }
    /**
     * Set Remedy value
     * @param \StructType\RemedyStructure $remedy
     * @return \StructType\FacilityConditionStructure
     */
    public function setRemedy(\StructType\RemedyStructure $remedy = null)
    {
        $this->Remedy = $remedy;
        return $this;
    }
    /**
     * Get MonitoringInfo value
     * @return \StructType\MonitoringInformationStructure|null
     */
    public function getMonitoringInfo()
    {
        return $this->MonitoringInfo;
    }
    /**
     * Set MonitoringInfo value
     * @param \StructType\MonitoringInformationStructure $monitoringInfo
     * @return \StructType\FacilityConditionStructure
     */
    public function setMonitoringInfo(\StructType\MonitoringInformationStructure $monitoringInfo = null)
    {
        $this->MonitoringInfo = $monitoringInfo;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\HalfOpenTimestampOutputRangeStructure|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod
     * @return \StructType\FacilityConditionStructure
     */
    public function setValidityPeriod(\StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityConditionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityConditionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
