<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityChangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for change to equipment availability. Basic structure defined in the first 1.0 SIRI XSd.
 * @subpackage Structs
 */
class FacilityChangeStructure extends AbstractStructBase
{
    /**
     * The EquipmentAvailability
     * Meta informations extracted from the WSDL
     * - documentation: Availability change for Equipment item.
     * - minOccurs: 0
     * @var \StructType\EquipmentAvailabilityStructure
     */
    public $EquipmentAvailability;
    /**
     * The SituationRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: SituationRef
     * @var \StructType\SituationRefStructure
     */
    public $SituationRef;
    /**
     * The MobilityDisruption
     * Meta informations extracted from the WSDL
     * - documentation: Effect of change on impaired access users.
     * - minOccurs: 0
     * @var \StructType\MobilityDisruptionStructure
     */
    public $MobilityDisruption;
    /**
     * Constructor method for FacilityChangeStructure
     * @uses FacilityChangeStructure::setEquipmentAvailability()
     * @uses FacilityChangeStructure::setSituationRef()
     * @uses FacilityChangeStructure::setMobilityDisruption()
     * @param \StructType\EquipmentAvailabilityStructure $equipmentAvailability
     * @param \StructType\SituationRefStructure $situationRef
     * @param \StructType\MobilityDisruptionStructure $mobilityDisruption
     */
    public function __construct(\StructType\EquipmentAvailabilityStructure $equipmentAvailability = null, \StructType\SituationRefStructure $situationRef = null, \StructType\MobilityDisruptionStructure $mobilityDisruption = null)
    {
        $this
            ->setEquipmentAvailability($equipmentAvailability)
            ->setSituationRef($situationRef)
            ->setMobilityDisruption($mobilityDisruption);
    }
    /**
     * Get EquipmentAvailability value
     * @return \StructType\EquipmentAvailabilityStructure|null
     */
    public function getEquipmentAvailability()
    {
        return $this->EquipmentAvailability;
    }
    /**
     * Set EquipmentAvailability value
     * @param \StructType\EquipmentAvailabilityStructure $equipmentAvailability
     * @return \StructType\FacilityChangeStructure
     */
    public function setEquipmentAvailability(\StructType\EquipmentAvailabilityStructure $equipmentAvailability = null)
    {
        $this->EquipmentAvailability = $equipmentAvailability;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @param \StructType\SituationRefStructure $situationRef
     * @return \StructType\FacilityChangeStructure
     */
    public function setSituationRef(\StructType\SituationRefStructure $situationRef = null)
    {
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Get MobilityDisruption value
     * @return \StructType\MobilityDisruptionStructure|null
     */
    public function getMobilityDisruption()
    {
        return $this->MobilityDisruption;
    }
    /**
     * Set MobilityDisruption value
     * @param \StructType\MobilityDisruptionStructure $mobilityDisruption
     * @return \StructType\FacilityChangeStructure
     */
    public function setMobilityDisruption(\StructType\MobilityDisruptionStructure $mobilityDisruption = null)
    {
        $this->MobilityDisruption = $mobilityDisruption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityChangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
