<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Facilities StructType
 * Meta informations extracted from the WSDL
 * - documentation: Facilities available for VEHICLE JOURNEY (+SIRI 2.0)
 * @subpackage Structs
 */
class Facilities extends AbstractStructBase
{
    /**
     * The AffectedFacility
     * Meta informations extracted from the WSDL
     * - documentation: Facililitiy available for VEHICLE JOURNEY (+SIRI 2.0)
     * - maxOccurs: unbounded
     * @var \StructType\AffectedFacilityStructure[]
     */
    public $AffectedFacility;
    /**
     * Constructor method for Facilities
     * @uses Facilities::setAffectedFacility()
     * @param \StructType\AffectedFacilityStructure[] $affectedFacility
     */
    public function __construct(array $affectedFacility = array())
    {
        $this
            ->setAffectedFacility($affectedFacility);
    }
    /**
     * Get AffectedFacility value
     * @return \StructType\AffectedFacilityStructure[]|null
     */
    public function getAffectedFacility()
    {
        return $this->AffectedFacility;
    }
    /**
     * Set AffectedFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedFacilityStructure[] $affectedFacility
     * @return \StructType\Facilities
     */
    public function setAffectedFacility(array $affectedFacility = array())
    {
        foreach ($affectedFacility as $facilitiesAffectedFacilityItem) {
            // validation for constraint: itemType
            if (!$facilitiesAffectedFacilityItem instanceof \StructType\AffectedFacilityStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedFacility property can only contain items of \StructType\AffectedFacilityStructure, "%s" given', is_object($facilitiesAffectedFacilityItem) ? get_class($facilitiesAffectedFacilityItem) : gettype($facilitiesAffectedFacilityItem)), __LINE__);
            }
        }
        $this->AffectedFacility = $affectedFacility;
        return $this;
    }
    /**
     * Add item to AffectedFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedFacilityStructure $item
     * @return \StructType\Facilities
     */
    public function addToAffectedFacility(\StructType\AffectedFacilityStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedFacilityStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedFacility property can only contain items of \StructType\AffectedFacilityStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedFacility[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Facilities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
