<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedTimetableSubscriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Subscription Request for the Estimated Timetable Service.
 * @subpackage Structs
 */
class EstimatedTimetableSubscriptionStructure extends AbstractSubscriptionStructure
{
    /**
     * The EstimatedTimetableRequest
     * Meta informations extracted from the WSDL
     * - ref: EstimatedTimetableRequest
     * @var \StructType\EstimatedTimetableRequestStructure
     */
    public $EstimatedTimetableRequest;
    /**
     * The IncrementalUpdates
     * @var bool
     */
    public $IncrementalUpdates;
    /**
     * The ChangeBeforeUpdates
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S",
     * "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ChangeBeforeUpdates;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for EstimatedTimetableSubscriptionStructure
     * @uses EstimatedTimetableSubscriptionStructure::setEstimatedTimetableRequest()
     * @uses EstimatedTimetableSubscriptionStructure::setIncrementalUpdates()
     * @uses EstimatedTimetableSubscriptionStructure::setChangeBeforeUpdates()
     * @uses EstimatedTimetableSubscriptionStructure::setExtensions()
     * @param \StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest
     * @param bool $incrementalUpdates
     * @param string $changeBeforeUpdates
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest = null, $incrementalUpdates = null, $changeBeforeUpdates = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setEstimatedTimetableRequest($estimatedTimetableRequest)
            ->setIncrementalUpdates($incrementalUpdates)
            ->setChangeBeforeUpdates($changeBeforeUpdates)
            ->setExtensions($extensions);
    }
    /**
     * Get EstimatedTimetableRequest value
     * @return \StructType\EstimatedTimetableRequestStructure|null
     */
    public function getEstimatedTimetableRequest()
    {
        return $this->EstimatedTimetableRequest;
    }
    /**
     * Set EstimatedTimetableRequest value
     * @param \StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest
     * @return \StructType\EstimatedTimetableSubscriptionStructure
     */
    public function setEstimatedTimetableRequest(\StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest = null)
    {
        $this->EstimatedTimetableRequest = $estimatedTimetableRequest;
        return $this;
    }
    /**
     * Get IncrementalUpdates value
     * @return bool|null
     */
    public function getIncrementalUpdates()
    {
        return $this->IncrementalUpdates;
    }
    /**
     * Set IncrementalUpdates value
     * @param bool $incrementalUpdates
     * @return \StructType\EstimatedTimetableSubscriptionStructure
     */
    public function setIncrementalUpdates($incrementalUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($incrementalUpdates) && !is_bool($incrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incrementalUpdates)), __LINE__);
        }
        $this->IncrementalUpdates = $incrementalUpdates;
        return $this;
    }
    /**
     * Get ChangeBeforeUpdates value
     * @return string|null
     */
    public function getChangeBeforeUpdates()
    {
        return $this->ChangeBeforeUpdates;
    }
    /**
     * Set ChangeBeforeUpdates value
     * @param string $changeBeforeUpdates
     * @return \StructType\EstimatedTimetableSubscriptionStructure
     */
    public function setChangeBeforeUpdates($changeBeforeUpdates = null)
    {
        // validation for constraint: string
        if (!is_null($changeBeforeUpdates) && !is_string($changeBeforeUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeBeforeUpdates)), __LINE__);
        }
        $this->ChangeBeforeUpdates = $changeBeforeUpdates;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\EstimatedTimetableSubscriptionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedTimetableSubscriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
