<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorConditionElementStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Standard ErrorConditions for Service request.
 * @subpackage Structs
 */
class ErrorConditionElementStructure extends AbstractStructBase
{
    /**
     * The UnapprovedKeyAccessError
     * @var \StructType\UnapprovedKeyAccessStructure
     */
    public $UnapprovedKeyAccessError;
    /**
     * The UnknownParticipantError
     * @var \StructType\UnknownParticipantErrorStructure
     */
    public $UnknownParticipantError;
    /**
     * The UnknownEndpointError
     * @var \StructType\UnknownEndpointErrorStructure
     */
    public $UnknownEndpointError;
    /**
     * The EndpointDeniedAccessError
     * @var \StructType\EndpointDeniedAccessStructure
     */
    public $EndpointDeniedAccessError;
    /**
     * The EndpointNotAvailableAccessError
     * @var \StructType\EndpointNotAvailableAccessStructure
     */
    public $EndpointNotAvailableAccessError;
    /**
     * The ServiceNotAvailableError
     * @var \StructType\ServiceNotAvailableErrorStructure
     */
    public $ServiceNotAvailableError;
    /**
     * The CapabilityNotSupportedError
     * @var \StructType\CapabilityNotSupportedErrorStructure
     */
    public $CapabilityNotSupportedError;
    /**
     * The AccessNotAllowedError
     * @var \StructType\AccessNotAllowedErrorStructure
     */
    public $AccessNotAllowedError;
    /**
     * The InvalidDataReferencesError
     * @var \StructType\InvalidDataReferencesErrorStructure
     */
    public $InvalidDataReferencesError;
    /**
     * The BeyondDataHorizon
     * @var \StructType\BeyondDataHorizonErrorStructure
     */
    public $BeyondDataHorizon;
    /**
     * The NoInfoForTopicError
     * @var \StructType\NoInfoForTopicErrorStructure
     */
    public $NoInfoForTopicError;
    /**
     * The ParametersIgnoredError
     * @var \StructType\ParametersIgnoredErrorStructure
     */
    public $ParametersIgnoredError;
    /**
     * The UnknownExtensionsError
     * @var \StructType\UnknownExtensionsErrorStructure
     */
    public $UnknownExtensionsError;
    /**
     * The AllowedResourceUsageExceededError
     * @var \StructType\AllowedResourceUsageExceededErrorStructure
     */
    public $AllowedResourceUsageExceededError;
    /**
     * The OtherError
     * @var \StructType\OtherErrorStructure
     */
    public $OtherError;
    /**
     * The UnknownSubscriptionError
     * Meta informations extracted from the WSDL
     * - ref: UnknownSubscriptionError
     * @var \StructType\UnknownSubscriptionErrorStructure
     */
    public $UnknownSubscriptionError;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Text description of error.
     * - minOccurs: 0
     * @var \StructType\ErrorDescriptionStructure
     */
    public $Description;
    /**
     * Constructor method for ErrorConditionElementStructure
     * @uses ErrorConditionElementStructure::setUnapprovedKeyAccessError()
     * @uses ErrorConditionElementStructure::setUnknownParticipantError()
     * @uses ErrorConditionElementStructure::setUnknownEndpointError()
     * @uses ErrorConditionElementStructure::setEndpointDeniedAccessError()
     * @uses ErrorConditionElementStructure::setEndpointNotAvailableAccessError()
     * @uses ErrorConditionElementStructure::setServiceNotAvailableError()
     * @uses ErrorConditionElementStructure::setCapabilityNotSupportedError()
     * @uses ErrorConditionElementStructure::setAccessNotAllowedError()
     * @uses ErrorConditionElementStructure::setInvalidDataReferencesError()
     * @uses ErrorConditionElementStructure::setBeyondDataHorizon()
     * @uses ErrorConditionElementStructure::setNoInfoForTopicError()
     * @uses ErrorConditionElementStructure::setParametersIgnoredError()
     * @uses ErrorConditionElementStructure::setUnknownExtensionsError()
     * @uses ErrorConditionElementStructure::setAllowedResourceUsageExceededError()
     * @uses ErrorConditionElementStructure::setOtherError()
     * @uses ErrorConditionElementStructure::setUnknownSubscriptionError()
     * @uses ErrorConditionElementStructure::setDescription()
     * @param \StructType\UnapprovedKeyAccessStructure $unapprovedKeyAccessError
     * @param \StructType\UnknownParticipantErrorStructure $unknownParticipantError
     * @param \StructType\UnknownEndpointErrorStructure $unknownEndpointError
     * @param \StructType\EndpointDeniedAccessStructure $endpointDeniedAccessError
     * @param \StructType\EndpointNotAvailableAccessStructure $endpointNotAvailableAccessError
     * @param \StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError
     * @param \StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError
     * @param \StructType\AccessNotAllowedErrorStructure $accessNotAllowedError
     * @param \StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError
     * @param \StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon
     * @param \StructType\NoInfoForTopicErrorStructure $noInfoForTopicError
     * @param \StructType\ParametersIgnoredErrorStructure $parametersIgnoredError
     * @param \StructType\UnknownExtensionsErrorStructure $unknownExtensionsError
     * @param \StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError
     * @param \StructType\OtherErrorStructure $otherError
     * @param \StructType\UnknownSubscriptionErrorStructure $unknownSubscriptionError
     * @param \StructType\ErrorDescriptionStructure $description
     */
    public function __construct(\StructType\UnapprovedKeyAccessStructure $unapprovedKeyAccessError = null, \StructType\UnknownParticipantErrorStructure $unknownParticipantError = null, \StructType\UnknownEndpointErrorStructure $unknownEndpointError = null, \StructType\EndpointDeniedAccessStructure $endpointDeniedAccessError = null, \StructType\EndpointNotAvailableAccessStructure $endpointNotAvailableAccessError = null, \StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError = null, \StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError = null, \StructType\AccessNotAllowedErrorStructure $accessNotAllowedError = null, \StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError = null, \StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon = null, \StructType\NoInfoForTopicErrorStructure $noInfoForTopicError = null, \StructType\ParametersIgnoredErrorStructure $parametersIgnoredError = null, \StructType\UnknownExtensionsErrorStructure $unknownExtensionsError = null, \StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError = null, \StructType\OtherErrorStructure $otherError = null, \StructType\UnknownSubscriptionErrorStructure $unknownSubscriptionError = null, \StructType\ErrorDescriptionStructure $description = null)
    {
        $this
            ->setUnapprovedKeyAccessError($unapprovedKeyAccessError)
            ->setUnknownParticipantError($unknownParticipantError)
            ->setUnknownEndpointError($unknownEndpointError)
            ->setEndpointDeniedAccessError($endpointDeniedAccessError)
            ->setEndpointNotAvailableAccessError($endpointNotAvailableAccessError)
            ->setServiceNotAvailableError($serviceNotAvailableError)
            ->setCapabilityNotSupportedError($capabilityNotSupportedError)
            ->setAccessNotAllowedError($accessNotAllowedError)
            ->setInvalidDataReferencesError($invalidDataReferencesError)
            ->setBeyondDataHorizon($beyondDataHorizon)
            ->setNoInfoForTopicError($noInfoForTopicError)
            ->setParametersIgnoredError($parametersIgnoredError)
            ->setUnknownExtensionsError($unknownExtensionsError)
            ->setAllowedResourceUsageExceededError($allowedResourceUsageExceededError)
            ->setOtherError($otherError)
            ->setUnknownSubscriptionError($unknownSubscriptionError)
            ->setDescription($description);
    }
    /**
     * Get UnapprovedKeyAccessError value
     * @return \StructType\UnapprovedKeyAccessStructure|null
     */
    public function getUnapprovedKeyAccessError()
    {
        return $this->UnapprovedKeyAccessError;
    }
    /**
     * Set UnapprovedKeyAccessError value
     * @param \StructType\UnapprovedKeyAccessStructure $unapprovedKeyAccessError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setUnapprovedKeyAccessError(\StructType\UnapprovedKeyAccessStructure $unapprovedKeyAccessError = null)
    {
        $this->UnapprovedKeyAccessError = $unapprovedKeyAccessError;
        return $this;
    }
    /**
     * Get UnknownParticipantError value
     * @return \StructType\UnknownParticipantErrorStructure|null
     */
    public function getUnknownParticipantError()
    {
        return $this->UnknownParticipantError;
    }
    /**
     * Set UnknownParticipantError value
     * @param \StructType\UnknownParticipantErrorStructure $unknownParticipantError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setUnknownParticipantError(\StructType\UnknownParticipantErrorStructure $unknownParticipantError = null)
    {
        $this->UnknownParticipantError = $unknownParticipantError;
        return $this;
    }
    /**
     * Get UnknownEndpointError value
     * @return \StructType\UnknownEndpointErrorStructure|null
     */
    public function getUnknownEndpointError()
    {
        return $this->UnknownEndpointError;
    }
    /**
     * Set UnknownEndpointError value
     * @param \StructType\UnknownEndpointErrorStructure $unknownEndpointError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setUnknownEndpointError(\StructType\UnknownEndpointErrorStructure $unknownEndpointError = null)
    {
        $this->UnknownEndpointError = $unknownEndpointError;
        return $this;
    }
    /**
     * Get EndpointDeniedAccessError value
     * @return \StructType\EndpointDeniedAccessStructure|null
     */
    public function getEndpointDeniedAccessError()
    {
        return $this->EndpointDeniedAccessError;
    }
    /**
     * Set EndpointDeniedAccessError value
     * @param \StructType\EndpointDeniedAccessStructure $endpointDeniedAccessError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setEndpointDeniedAccessError(\StructType\EndpointDeniedAccessStructure $endpointDeniedAccessError = null)
    {
        $this->EndpointDeniedAccessError = $endpointDeniedAccessError;
        return $this;
    }
    /**
     * Get EndpointNotAvailableAccessError value
     * @return \StructType\EndpointNotAvailableAccessStructure|null
     */
    public function getEndpointNotAvailableAccessError()
    {
        return $this->EndpointNotAvailableAccessError;
    }
    /**
     * Set EndpointNotAvailableAccessError value
     * @param \StructType\EndpointNotAvailableAccessStructure $endpointNotAvailableAccessError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setEndpointNotAvailableAccessError(\StructType\EndpointNotAvailableAccessStructure $endpointNotAvailableAccessError = null)
    {
        $this->EndpointNotAvailableAccessError = $endpointNotAvailableAccessError;
        return $this;
    }
    /**
     * Get ServiceNotAvailableError value
     * @return \StructType\ServiceNotAvailableErrorStructure|null
     */
    public function getServiceNotAvailableError()
    {
        return $this->ServiceNotAvailableError;
    }
    /**
     * Set ServiceNotAvailableError value
     * @param \StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setServiceNotAvailableError(\StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError = null)
    {
        $this->ServiceNotAvailableError = $serviceNotAvailableError;
        return $this;
    }
    /**
     * Get CapabilityNotSupportedError value
     * @return \StructType\CapabilityNotSupportedErrorStructure|null
     */
    public function getCapabilityNotSupportedError()
    {
        return $this->CapabilityNotSupportedError;
    }
    /**
     * Set CapabilityNotSupportedError value
     * @param \StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setCapabilityNotSupportedError(\StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError = null)
    {
        $this->CapabilityNotSupportedError = $capabilityNotSupportedError;
        return $this;
    }
    /**
     * Get AccessNotAllowedError value
     * @return \StructType\AccessNotAllowedErrorStructure|null
     */
    public function getAccessNotAllowedError()
    {
        return $this->AccessNotAllowedError;
    }
    /**
     * Set AccessNotAllowedError value
     * @param \StructType\AccessNotAllowedErrorStructure $accessNotAllowedError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setAccessNotAllowedError(\StructType\AccessNotAllowedErrorStructure $accessNotAllowedError = null)
    {
        $this->AccessNotAllowedError = $accessNotAllowedError;
        return $this;
    }
    /**
     * Get InvalidDataReferencesError value
     * @return \StructType\InvalidDataReferencesErrorStructure|null
     */
    public function getInvalidDataReferencesError()
    {
        return $this->InvalidDataReferencesError;
    }
    /**
     * Set InvalidDataReferencesError value
     * @param \StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setInvalidDataReferencesError(\StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError = null)
    {
        $this->InvalidDataReferencesError = $invalidDataReferencesError;
        return $this;
    }
    /**
     * Get BeyondDataHorizon value
     * @return \StructType\BeyondDataHorizonErrorStructure|null
     */
    public function getBeyondDataHorizon()
    {
        return $this->BeyondDataHorizon;
    }
    /**
     * Set BeyondDataHorizon value
     * @param \StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setBeyondDataHorizon(\StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon = null)
    {
        $this->BeyondDataHorizon = $beyondDataHorizon;
        return $this;
    }
    /**
     * Get NoInfoForTopicError value
     * @return \StructType\NoInfoForTopicErrorStructure|null
     */
    public function getNoInfoForTopicError()
    {
        return $this->NoInfoForTopicError;
    }
    /**
     * Set NoInfoForTopicError value
     * @param \StructType\NoInfoForTopicErrorStructure $noInfoForTopicError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setNoInfoForTopicError(\StructType\NoInfoForTopicErrorStructure $noInfoForTopicError = null)
    {
        $this->NoInfoForTopicError = $noInfoForTopicError;
        return $this;
    }
    /**
     * Get ParametersIgnoredError value
     * @return \StructType\ParametersIgnoredErrorStructure|null
     */
    public function getParametersIgnoredError()
    {
        return $this->ParametersIgnoredError;
    }
    /**
     * Set ParametersIgnoredError value
     * @param \StructType\ParametersIgnoredErrorStructure $parametersIgnoredError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setParametersIgnoredError(\StructType\ParametersIgnoredErrorStructure $parametersIgnoredError = null)
    {
        $this->ParametersIgnoredError = $parametersIgnoredError;
        return $this;
    }
    /**
     * Get UnknownExtensionsError value
     * @return \StructType\UnknownExtensionsErrorStructure|null
     */
    public function getUnknownExtensionsError()
    {
        return $this->UnknownExtensionsError;
    }
    /**
     * Set UnknownExtensionsError value
     * @param \StructType\UnknownExtensionsErrorStructure $unknownExtensionsError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setUnknownExtensionsError(\StructType\UnknownExtensionsErrorStructure $unknownExtensionsError = null)
    {
        $this->UnknownExtensionsError = $unknownExtensionsError;
        return $this;
    }
    /**
     * Get AllowedResourceUsageExceededError value
     * @return \StructType\AllowedResourceUsageExceededErrorStructure|null
     */
    public function getAllowedResourceUsageExceededError()
    {
        return $this->AllowedResourceUsageExceededError;
    }
    /**
     * Set AllowedResourceUsageExceededError value
     * @param \StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setAllowedResourceUsageExceededError(\StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError = null)
    {
        $this->AllowedResourceUsageExceededError = $allowedResourceUsageExceededError;
        return $this;
    }
    /**
     * Get OtherError value
     * @return \StructType\OtherErrorStructure|null
     */
    public function getOtherError()
    {
        return $this->OtherError;
    }
    /**
     * Set OtherError value
     * @param \StructType\OtherErrorStructure $otherError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setOtherError(\StructType\OtherErrorStructure $otherError = null)
    {
        $this->OtherError = $otherError;
        return $this;
    }
    /**
     * Get UnknownSubscriptionError value
     * @return \StructType\UnknownSubscriptionErrorStructure|null
     */
    public function getUnknownSubscriptionError()
    {
        return $this->UnknownSubscriptionError;
    }
    /**
     * Set UnknownSubscriptionError value
     * @param \StructType\UnknownSubscriptionErrorStructure $unknownSubscriptionError
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setUnknownSubscriptionError(\StructType\UnknownSubscriptionErrorStructure $unknownSubscriptionError = null)
    {
        $this->UnknownSubscriptionError = $unknownSubscriptionError;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ErrorDescriptionStructure|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\ErrorDescriptionStructure $description
     * @return \StructType\ErrorConditionElementStructure
     */
    public function setDescription(\StructType\ErrorDescriptionStructure $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ErrorConditionElementStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
